/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionHierarchyWalker;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionMappingCollector;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionTuple;
import org.camunda.bpm.engine.impl.tree.OutputVariablesPropagator;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;
import org.camunda.bpm.engine.impl.tree.TreeWalker;

public class AbstractBpmnActivityBehavior
extends FlowNodeActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    @Override
    protected void leave(ActivityExecution execution) {
        PvmActivity currentActivity = execution.getActivity();
        ActivityImpl compensationHandler = ((ActivityImpl)currentActivity).findCompensationHandler();
        if (compensationHandler != null && !this.isCompensationEventSubprocess(compensationHandler)) {
            this.createCompensateEventSubscription(execution, compensationHandler);
        }
        super.leave(execution);
    }

    protected boolean isCompensationEventSubprocess(ActivityImpl activity) {
        return activity.isCompensationHandler() && activity.isSubProcessScope() && activity.isTriggeredByEvent();
    }

    protected void createCompensateEventSubscription(ActivityExecution execution, ActivityImpl compensationHandler) {
        PvmActivity currentActivity = execution.getActivity();
        ActivityExecution scopeExecution = execution.findExecutionForFlowScope(currentActivity.getFlowScope());
        CompensateEventSubscriptionEntity.createAndInsert((ExecutionEntity)scopeExecution, compensationHandler);
    }

    protected void propagateExceptionAsError(Exception exception, ActivityExecution execution) throws Exception {
        if (this.isProcessEngineExceptionWithoutCause(exception) || this.isTransactionNotActive()) {
            throw exception;
        }
        this.propagateError(null, exception, execution);
    }

    protected void executeWithErrorPropagation(ActivityExecution execution, Callable<Void> toExecute) throws Exception {
        String activityInstanceId = execution.getActivityInstanceId();
        try {
            toExecute.call();
        }
        catch (Exception ex) {
            if (activityInstanceId.equals(execution.getActivityInstanceId())) {
                try {
                    this.propagateException(execution, ex);
                }
                catch (ErrorPropagationException e) {
                    LOG.errorPropagationException(activityInstanceId, e.getCause());
                    throw ex;
                }
            }
            throw ex;
        }
    }

    protected void propagateException(ActivityExecution execution, Exception ex) throws Exception {
        BpmnError bpmnError = this.checkIfCauseOfExceptionIsBpmnError(ex);
        if (bpmnError != null) {
            this.propagateBpmnError(bpmnError, execution);
        } else {
            this.propagateExceptionAsError(ex, execution);
        }
    }

    protected BpmnError checkIfCauseOfExceptionIsBpmnError(Throwable e) {
        if (e instanceof BpmnError) {
            return (BpmnError)e;
        }
        if (e.getCause() == null) {
            return null;
        }
        return this.checkIfCauseOfExceptionIsBpmnError(e.getCause());
    }

    protected boolean isTransactionNotActive() {
        return !Context.getCommandContext().getTransactionContext().isTransactionActive();
    }

    protected boolean isProcessEngineExceptionWithoutCause(Exception exception) {
        return exception instanceof ProcessEngineException && exception.getCause() == null;
    }

    protected void propagateBpmnError(BpmnError error, ActivityExecution execution) throws Exception {
        this.propagateError(error.getErrorCode(), null, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void propagateError(String errorCode, Exception origException, ActivityExecution execution) throws Exception {
        ActivityExecutionHierarchyWalker walker = new ActivityExecutionHierarchyWalker(execution);
        final ErrorDeclarationForProcessInstanceFinder errorDeclarationFinder = new ErrorDeclarationForProcessInstanceFinder(origException, errorCode);
        ActivityExecutionMappingCollector activityExecutionMappingCollector = new ActivityExecutionMappingCollector(execution);
        walker.addScopePreVisitor(errorDeclarationFinder);
        walker.addExecutionPreVisitor(activityExecutionMappingCollector);
        walker.addExecutionPreVisitor(new OutputVariablesPropagator());
        try {
            walker.walkUntil(new TreeWalker.WalkCondition<ActivityExecutionTuple>(){

                @Override
                public boolean isFulfilled(ActivityExecutionTuple element) {
                    return errorDeclarationFinder.getErrorEventDefinition() != null || element == null;
                }
            });
        }
        catch (Exception e) {
            throw new ErrorPropagationException((Throwable)e);
        }
        PvmActivity errorHandlingActivity = errorDeclarationFinder.getErrorHandlerActivity();
        if (errorHandlingActivity == null) {
            if (origException != null) throw origException;
            LOG.missingBoundaryCatchEvent(execution.getActivity().getId(), errorCode);
            execution.end(true);
            return;
        } else {
            ErrorEventDefinition errorDefinition = errorDeclarationFinder.getErrorEventDefinition();
            PvmExecutionImpl errorHandlingExecution = activityExecutionMappingCollector.getExecutionForScope(errorHandlingActivity.getEventScope());
            if (errorDefinition.getErrorCodeVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorCodeVariable(), errorCode);
            }
            errorHandlingExecution.executeActivity(errorHandlingActivity);
        }
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if ("compensationDone".equals(signalName)) {
            this.signalCompensationDone(execution);
        } else {
            super.signal(execution, signalName, signalData);
        }
    }

    protected void signalCompensationDone(ActivityExecution execution) {
        if (((PvmExecutionImpl)execution).getNonEventScopeExecutions().isEmpty()) {
            if (execution.getParent() != null) {
                ActivityExecution parent = execution.getParent();
                execution.remove();
                parent.signal("compensationDone", null);
            }
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }

    protected class ErrorPropagationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ErrorPropagationException(Throwable cause) {
            super(cause);
        }
    }

    public class ErrorDeclarationForProcessInstanceFinder
    implements TreeVisitor<PvmScope> {
        protected Exception exception;
        protected String errorCode;
        protected PvmActivity errorHandlerActivity;
        protected ErrorEventDefinition errorEventDefinition;

        public ErrorDeclarationForProcessInstanceFinder(Exception exception, String errorCode) {
            this.exception = exception;
            this.errorCode = errorCode;
        }

        @Override
        public void visit(PvmScope scope) {
            List<ErrorEventDefinition> errorEventDefinitions = scope.getProperties().get(BpmnProperties.ERROR_EVENT_DEFINITIONS);
            for (ErrorEventDefinition errorEventDefinition : errorEventDefinitions) {
                if ((this.exception == null || !errorEventDefinition.catchesException(this.exception)) && (this.exception != null || !errorEventDefinition.catchesError(this.errorCode))) continue;
                this.errorHandlerActivity = scope.getProcessDefinition().findActivity(errorEventDefinition.getHandlerActivityId());
                this.errorEventDefinition = errorEventDefinition;
                break;
            }
        }

        public PvmActivity getErrorHandlerActivity() {
            return this.errorHandlerActivity;
        }

        public ErrorEventDefinition getErrorEventDefinition() {
            return this.errorEventDefinition;
        }
    }
}

