/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class LegacyBehavior {
    private static final Logger log = Logger.getLogger(LegacyBehavior.class.getName());
    protected boolean isEventSubprocessScope = true;
    protected boolean isSequentialMiSubprocessScope = true;
    protected boolean isConcurrentScopeExecutionEnabled = false;
    private static LegacyBehavior DEFAULT_BEHAVIOR = new LegacyBehavior(false);

    public LegacyBehavior(boolean isOn) {
        if (isOn) {
            this.isEventSubprocessScope = false;
            this.isSequentialMiSubprocessScope = false;
            this.isConcurrentScopeExecutionEnabled = true;
        }
    }

    public static LegacyBehavior get() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return DEFAULT_BEHAVIOR;
        }
        return Context.getProcessEngineConfiguration().getConfiguredLegacyBehavior();
    }

    public boolean isEventSubprocessScope() {
        return this.isEventSubprocessScope;
    }

    public boolean isSequentialMiSubprocessScope() {
        return this.isSequentialMiSubprocessScope;
    }

    public boolean isConcurrentScopeExecutionEnabled() {
        return this.isConcurrentScopeExecutionEnabled;
    }

    public void createConcurrentScope(PvmExecutionImpl execution) {
        this.ensureScope(execution);
        log.fine("[LEGACY BEHAVIOR]: create concurrent scope execution " + execution);
        execution.setConcurrent(true);
    }

    public void pruneConcurrentScope(PvmExecutionImpl execution) {
        this.ensureConcurrentScope(execution);
        log.fine("[LEGACY BEHAVIOR]: concurrent scope execution is pruned " + execution);
        execution.setConcurrent(false);
    }

    public void cancelConcurrentScope(PvmExecutionImpl execution, PvmActivity cancellingActivity) {
        this.ensureConcurrentScope(execution);
        log.fine("[LEGACY BEHAVIOR]: cancel concurrent scope execution " + execution);
        execution.interrupt("Cancel scope activity " + cancellingActivity + " executed.");
        execution.setActivity((PvmActivity)((Object)cancellingActivity.getFlowScope()));
        execution.leaveActivityInstance();
        execution.interrupt("Cancel scope activity " + cancellingActivity + " executed.");
        execution.destroy();
    }

    public void destroyConcurrentScope(PvmExecutionImpl execution) {
        this.ensureConcurrentScope(execution);
        log.fine("[LEGACY BEHAVIOR]: destroy concurrent scope execution " + execution);
        execution.destroy();
    }

    public boolean eventSubprocessComplete(ActivityExecution scopeExecution) {
        boolean perfromLegacyBehavior = this.isLegacyBehaviorRequired(scopeExecution, this.isEventSubprocessScope);
        if (perfromLegacyBehavior) {
            log.fine("[LEGACY BEHAVIOR]: complete non-scope event subprocess.");
            scopeExecution.end(false);
        }
        return perfromLegacyBehavior;
    }

    public boolean eventSubprocessConcurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        boolean performLegacyBehavior = this.isLegacyBehaviorRequired(endedExecution, this.isEventSubprocessScope);
        if (performLegacyBehavior) {
            log.fine("[LEGACY BEHAVIOR]: end concurrent execution in event subprocess.");
            endedExecution.end(false);
        }
        return performLegacyBehavior;
    }

    public ScopeImpl normalizeSecondNonScope(ScopeImpl scope) {
        if (!this.isEventSubprocessScope) {
            if (!scope.isScope()) {
                log.fine("[LEGACY BEHAVIOR]: normalizing second non-scope scope.");
                return scope.getFlowScope();
            }
            return scope;
        }
        return scope;
    }

    protected boolean isLegacyBehaviorRequired(ActivityExecution scopeExecution, boolean isLegacyBehaviorTurnedOff) {
        PvmActivity activity;
        if (!isLegacyBehaviorTurnedOff) {
            return true;
        }
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = scopeExecution.createActivityExecutionMapping();
        return activityExecutionMapping.get(activity = scopeExecution.getActivity()) == activityExecutionMapping.get(activity.getFlowScope());
    }

    public PvmExecutionImpl getScopeExecution(ScopeImpl scope, Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping) {
        ScopeImpl flowScope = scope.getFlowScope();
        return activityExecutionMapping.get(flowScope);
    }

    protected void ensureConcurrentScope(PvmExecutionImpl execution) {
        this.ensureScope(execution);
        this.ensureConcurrent(execution);
    }

    private void ensureConcurrent(PvmExecutionImpl execution) {
        if (!execution.isConcurrent()) {
            throw new ProcessEngineException("Execution must be concurrent.");
        }
    }

    private void ensureScope(PvmExecutionImpl execution) {
        if (!execution.isScope()) {
            throw new ProcessEngineException("Execution must be scope.");
        }
    }

    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(List<PvmExecutionImpl> scopeExecutions, List<ScopeImpl> scopes) {
        int numOfMissingExecutions = scopes.size() - scopeExecutions.size();
        Collections.reverse(scopeExecutions);
        Collections.reverse(scopes);
        HashMap<ScopeImpl, PvmExecutionImpl> mapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
        mapping.put(scopes.get(0), scopeExecutions.get(0));
        int executionCounter = 0;
        for (int i = 1; i < scopes.size(); ++i) {
            ActivityImpl scope = (ActivityImpl)scopes.get(i);
            PvmExecutionImpl execution = scopeExecutions.get(executionCounter);
            if (numOfMissingExecutions > 0) {
                ActivityBehavior activityBehavior = scope.getActivityBehavior();
                ActivityBehavior parentActivityBehavior = (ActivityBehavior)(scope.getFlowScope() != null ? scope.getFlowScope().getActivityBehavior() : null);
                if (this.isEventSubprocessScope && activityBehavior instanceof EventSubProcessActivityBehavior || this.isSequentialMiSubprocessScope && activityBehavior instanceof SubProcessActivityBehavior && parentActivityBehavior instanceof SequentialMultiInstanceActivityBehavior) {
                    --numOfMissingExecutions;
                } else {
                    ++executionCounter;
                }
            }
            mapping.put(scope, execution);
        }
        return mapping;
    }
}

