/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.SuspendedEntityInteractionException;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.scope.CoreVariableStore;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.MessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntityVariableStore;
import org.camunda.bpm.engine.impl.persistence.entity.HistoryAwareStartContext;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.util.FormPropertyStartContext;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.util.BitMaskUtil;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ExecutionEntity
extends PvmExecutionImpl
implements Execution,
ProcessInstance,
DbEntity,
HasDbRevision,
HasDbReferences {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecutionEntity.class.getName());
    public static final int EVENT_SUBSCRIPTIONS_STATE_BIT = 1;
    public static final int TASKS_STATE_BIT = 2;
    public static final int JOBS_STATE_BIT = 3;
    public static final int INCIDENT_STATE_BIT = 4;
    public static final int VARIABLES_STATE_BIT = 5;
    public static final int SUB_PROCESS_INSTANCE_STATE_BIT = 6;
    public static final int SUB_CASE_INSTANCE_STATE_BIT = 7;
    protected transient ExecutionEntity processInstance;
    protected transient ExecutionEntity parent;
    protected transient List<ExecutionEntity> executions;
    protected transient ExecutionEntity superExecution;
    protected transient CaseExecutionEntity superCaseExecution;
    protected transient ExecutionEntity subProcessInstance;
    protected transient CaseExecutionEntity subCaseInstance;
    protected boolean shouldQueryForSubprocessInstance = false;
    protected boolean shouldQueryForSubCaseInstance = false;
    protected transient List<EventSubscriptionEntity> eventSubscriptions;
    protected transient List<JobEntity> jobs;
    protected transient List<TaskEntity> tasks;
    protected transient List<IncidentEntity> incidents;
    protected int cachedEntityState;
    protected transient ExecutionEntityVariableStore variableStore = new ExecutionEntityVariableStore(this);
    protected transient ExecutionEntity replacedBy;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected int revision = 1;
    protected String processDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String processInstanceId;
    protected String parentId;
    protected String superExecutionId;
    protected String superCaseExecutionId;

    public ExecutionEntity() {
    }

    public ExecutionEntity(ActivityImpl activityImpl) {
        if (activityImpl != null) {
            this.processInstanceStartContext = new HistoryAwareStartContext(activityImpl);
        }
    }

    @Override
    public ExecutionEntity createExecution() {
        return this.createExecution(false);
    }

    @Override
    public ExecutionEntity createExecution(boolean initializeExecutionStartContext) {
        ExecutionEntity createdExecution = this.newExecution(null);
        createdExecution.setSequenceCounter(this.getSequenceCounter());
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        createdExecution.activityInstanceId = this.activityInstanceId;
        if (initializeExecutionStartContext) {
            createdExecution.setStartContext(new ExecutionStartContext());
        } else if (this.startContext != null) {
            createdExecution.setStartContext(this.startContext);
        }
        createdExecution.skipCustomListeners = this.skipCustomListeners;
        createdExecution.skipIoMapping = this.skipIoMapping;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Child execution " + createdExecution + " created with parent " + this);
        }
        return createdExecution;
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        ExecutionEntity processInstance = this.getProcessInstance();
        String caseInstanceId = null;
        if (processInstance != null) {
            caseInstanceId = processInstance.getCaseInstanceId();
        }
        return this.createSubProcessInstance(processDefinition, businessKey, caseInstanceId);
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        ActivityImpl initial = (ActivityImpl)processDefinition.getInitial();
        ExecutionEntity subProcessInstance = this.createExecution(initial);
        subProcessInstance.setActivity(initial);
        this.shouldQueryForSubprocessInstance = true;
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.insert();
        subProcessInstance.setProcessInstance(subProcessInstance);
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(subProcessInstance.getScopeActivity())) {
            declaration.createSubscription(subProcessInstance);
        }
        List timerDeclarations = (List)processDefinition.getProperty("timerDeclarations");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                timerDeclaration.createTimerInstance(subProcessInstance);
            }
        }
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        if (caseInstanceId != null) {
            subProcessInstance.setCaseInstanceId(caseInstanceId);
        }
        this.fireHistoricSubProcessInstanceCreate();
        this.fireHistoricActivityInstanceUpdate();
        return subProcessInstance;
    }

    protected ExecutionEntity createExecution(ActivityImpl activity) {
        ExecutionEntity newExecution = new ExecutionEntity(activity);
        this.initializeAssociations(newExecution);
        return newExecution;
    }

    protected ExecutionEntity newExecution(ActivityImpl activity) {
        ExecutionEntity newExecution = this.createExecution(activity);
        newExecution.insert();
        return newExecution;
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance(businessKey);
        subCaseInstance.setSuperExecution(this);
        this.setSubCaseInstance(subCaseInstance);
        this.fireHistoricActivityInstanceUpdate();
        return subCaseInstance;
    }

    public void fireHistoricSubProcessInstanceCreate() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_START, this)) {
            HistoryEventProducer eventFactory = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent hpise = eventFactory.createProcessInstanceStartEvt(this.subProcessInstance);
            eventHandler.handleEvent(hpise);
        }
    }

    public void fireHistoricActivityInstanceUpdate() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_UPDATE, this)) {
            HistoryEventProducer eventFactory = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent haie = eventFactory.createActivityInstanceUpdateEvt(this, null);
            eventHandler.handleEvent(haie);
        }
    }

    @Override
    public void initialize() {
        log.fine("initializing " + this);
        ScopeImpl scope = this.getScopeActivity();
        this.ensureParentInitialized();
        List variableDeclarations = (List)scope.getProperty("variableDeclarations");
        if (variableDeclarations != null) {
            for (VariableDeclaration variableDeclaration : variableDeclarations) {
                variableDeclaration.initialize(this, this.parent);
            }
        }
        this.initializeAssociations(this);
        this.executeIoMapping();
        List timerDeclarations = (List)scope.getProperty("timerDeclarations");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                timerDeclaration.createTimerInstance(this);
            }
        }
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(scope)) {
            declaration.createSubscription(this);
        }
    }

    protected void initializeAssociations(ExecutionEntity execution) {
        execution.executions = new ArrayList<ExecutionEntity>();
        execution.variableStore.setVariableInstances(new HashMap<String, VariableInstanceEntity>());
        execution.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        execution.jobs = new ArrayList<JobEntity>();
        execution.tasks = new ArrayList<TaskEntity>();
        execution.incidents = new ArrayList<IncidentEntity>();
        execution.cachedEntityState = 0;
    }

    public void startWithFormProperties(VariableMap properties) {
        if (this.isProcessInstanceExecution()) {
            ActivityImpl initial = this.processDefinition.getInitial();
            if (this.processInstanceStartContext != null) {
                initial = this.processInstanceStartContext.getInitial();
            }
            FormPropertyStartContext formPropertyStartContext = new FormPropertyStartContext(initial);
            formPropertyStartContext.setFormProperties(properties);
            this.processInstanceStartContext = formPropertyStartContext;
        }
        this.performOperation(PvmAtomicOperation.PROCESS_START);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ensureParentInitialized();
        this.ensureActivityInitialized();
        if (this.activity != null && this.activity.getIoMapping() != null && !this.skipIoMapping) {
            this.activity.getIoMapping().executeOutputParameters(this);
        }
        this.clearExecution();
        this.removeEventSubscriptionsExceptCompensation();
    }

    protected void clearExecution() {
        this.variableStore.removeVariablesWithoutFiringEvents();
        this.removeTasks(null);
        this.removeJobs();
        this.removeIncidents();
    }

    @Override
    public void interrupt(String reason, boolean skipCustomListeners, boolean skipIoMappings) {
        if (this.preserveScope) {
            this.removeActivityJobs(reason);
        } else {
            this.removeJobs();
            this.removeEventSubscriptionsExceptCompensation();
        }
        this.removeTasks(reason);
        super.interrupt(reason, skipCustomListeners, skipIoMappings);
    }

    protected void removeActivityJobs(String reason) {
        if (this.activityId != null) {
            for (JobEntity job : this.getJobs()) {
                if (!this.activityId.equals(job.getActivityId())) continue;
                job.delete();
                this.removeJob(job);
            }
        }
    }

    @Override
    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        if (operation instanceof AtomicOperation) {
            this.performOperation((AtomicOperation)operation);
        } else {
            super.performOperation(operation);
        }
    }

    @Override
    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        if (operation instanceof AtomicOperation) {
            this.performOperationSync((AtomicOperation)operation);
        } else {
            super.performOperationSync(operation);
        }
    }

    public void performOperation(AtomicOperation executionOperation) {
        if (executionOperation.isAsync(this)) {
            this.scheduleAtomicOperationAsync(executionOperation);
        } else {
            this.performOperationSync(executionOperation);
        }
    }

    public void performOperationSync(AtomicOperation executionOperation) {
        if (this.requiresUnsuspendedExecution(executionOperation)) {
            this.ensureNotSuspended();
        }
        Context.getCommandContext().performOperation(executionOperation, this);
    }

    protected void ensureNotSuspended() {
        if (this.isSuspended()) {
            throw new SuspendedEntityInteractionException("Execution " + this.id + " is suspended.");
        }
    }

    protected boolean requiresUnsuspendedExecution(AtomicOperation executionOperation) {
        return executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END && executionOperation != PvmAtomicOperation.TRANSITION_DESTROY_SCOPE && executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE && executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END && executionOperation != PvmAtomicOperation.TRANSITION_CREATE_SCOPE && executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_START && executionOperation != PvmAtomicOperation.DELETE_CASCADE && executionOperation != PvmAtomicOperation.DELETE_CASCADE_FIRE_ACTIVITY_END;
    }

    protected void scheduleAtomicOperationAsync(AtomicOperation executionOperation) {
        JobDeclaration messageJobDeclaration = null;
        List messageJobDeclarations = (List)this.getActivity().getProperty("messageJobDeclaration");
        if (messageJobDeclarations != null) {
            for (MessageJobDeclaration declaration : messageJobDeclarations) {
                if (!declaration.isApplicableForOperation(executionOperation)) continue;
                messageJobDeclaration = declaration;
                break;
            }
        }
        if (messageJobDeclaration == null) {
            throw new ProcessEngineException("Asynchronous continuation requires a message job declaration.");
        }
        MessageEntity message = (MessageEntity)messageJobDeclaration.createJobInstance(this);
        ((MessageJobDeclaration)messageJobDeclaration).setJobHandlerConfiguration(message, this, executionOperation);
        Context.getCommandContext().getJobManager().send(message);
    }

    @Override
    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public List<ExecutionEntity> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.executions = Context.getCommandContext().getExecutionManager().findChildExecutionsByParentExecutionId(this.id);
            }
        }
    }

    protected boolean isExecutionTreePrefetchEnabled() {
        return Context.getProcessEngineConfiguration().isExecutionTreePrefetchEnabled();
    }

    public void setExecutions(List<ExecutionEntity> executions) {
        this.executions = executions;
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    protected void ensureProcessDefinitionInitialized() {
        if (this.processDefinition == null && this.processDefinitionId != null) {
            ProcessDefinitionEntity deployedProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.setProcessDefinition(deployedProcessDefinition);
        }
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.processDefinitionId = processDefinition.getId();
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.processInstance = Context.getCommandContext().getExecutionManager().findExecutionById(this.processInstanceId);
            }
        }
    }

    @Override
    public void setProcessInstance(PvmExecutionImpl processInstance) {
        this.processInstance = (ExecutionEntity)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getProcessDefinition().findActivity(this.activityId));
        }
    }

    @Override
    public void setActivity(PvmActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = (String)activity.getProperty("name");
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    @Override
    protected String generateActivityInstanceId(String activityId) {
        if (activityId.equals(this.processDefinitionId)) {
            return this.processInstanceId;
        }
        String nextId = Context.getProcessEngineConfiguration().getIdGenerator().getNextId();
        String compositeId = activityId + ":" + nextId;
        if (compositeId.length() > 64) {
            return String.valueOf(nextId);
        }
        return compositeId;
    }

    @Override
    public ExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.parent = Context.getCommandContext().getExecutionManager().findExecutionById(this.parentId);
            }
        }
    }

    @Override
    public void setParent(PvmExecutionImpl parent) {
        this.parent = (ExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(PvmExecutionImpl superExecution) {
        this.superExecution = (ExecutionEntity)superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        this.superExecutionId = superExecution != null ? superExecution.getId() : null;
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.shouldQueryForSubprocessInstance = subProcessInstance != null;
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.shouldQueryForSubprocessInstance && this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    public String getSuperCaseExecutionId() {
        return this.superCaseExecutionId;
    }

    public void setSuperCaseExecutionId(String superCaseExecutionId) {
        this.superCaseExecutionId = superCaseExecutionId;
    }

    @Override
    public CaseExecutionEntity getSuperCaseExecution() {
        this.ensureSuperCaseExecutionInitialized();
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionEntity)superCaseExecution;
        if (superCaseExecution != null) {
            this.superCaseExecutionId = superCaseExecution.getId();
            this.caseInstanceId = superCaseExecution.getCaseInstanceId();
        } else {
            this.superCaseExecutionId = null;
            this.caseInstanceId = null;
        }
    }

    protected void ensureSuperCaseExecutionInitialized() {
        if (this.superCaseExecution == null && this.superCaseExecutionId != null) {
            this.superCaseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.superCaseExecutionId);
        }
    }

    @Override
    public CaseExecutionEntity getSubCaseInstance() {
        this.ensureSubCaseInstanceInitialized();
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.shouldQueryForSubCaseInstance = subCaseInstance != null;
        this.subCaseInstance = (CaseExecutionEntity)subCaseInstance;
    }

    protected void ensureSubCaseInstanceInitialized() {
        if (this.shouldQueryForSubCaseInstance && this.subCaseInstance == null) {
            this.subCaseInstance = Context.getCommandContext().getCaseExecutionManager().findSubCaseInstanceBySuperExecutionId(this.id);
        }
    }

    @Override
    public void removeFromParentScope() {
        ExecutionEntity parent = this.getParent();
        if (parent.isConcurrent()) {
            parent = parent.getParent();
        }
        if (parent != null) {
            parent.forceUpdate();
        }
        super.removeFromParentScope();
    }

    @Override
    public void remove() {
        super.remove();
        this.clearExecution();
        this.removeEventSubscriptions();
        Context.getCommandContext().getExecutionManager().deleteExecution(this);
    }

    protected void removeEventSubscriptionsExceptCompensation() {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptions();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if ("compensate".equals(eventSubscriptionEntity.getEventType())) continue;
            eventSubscriptionEntity.delete();
        }
    }

    public void removeEventSubscriptions() {
        for (EventSubscriptionEntity eventSubscription : this.getEventSubscriptions()) {
            if (this.replacedBy != null) {
                eventSubscription.setExecution(this.replacedBy);
                continue;
            }
            eventSubscription.delete();
        }
    }

    private void removeJobs() {
        for (JobEntity job : this.getJobs()) {
            if (this.replacedBy != null) {
                job.setExecution(this.replacedBy);
                continue;
            }
            job.delete();
        }
    }

    private void removeIncidents() {
        for (IncidentEntity incident : this.getIncidents()) {
            if (this.replacedBy != null) {
                incident.setExecution(this.replacedBy);
                continue;
            }
            incident.delete();
        }
    }

    private void removeTasks(String reason) {
        if (reason == null) {
            reason = "deleted";
        }
        for (TaskEntity task : this.getTasks()) {
            if (this.replacedBy != null) {
                if (task.getExecution() != null && task.getExecution() == this.replacedBy) continue;
                task.setExecution(this.replacedBy);
                this.replacedBy.addTask(task);
                continue;
            }
            task.delete(reason, false);
        }
    }

    @Override
    public ExecutionEntity getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(PvmExecutionImpl replacedBy) {
        this.replacedBy = (ExecutionEntity)replacedBy;
        CommandContext commandContext = Context.getCommandContext();
        DbEntityManager dbEntityManger = commandContext.getDbEntityManager();
        for (TaskEntity task : this.getTasks()) {
            task.setExecutionId(replacedBy.getId());
            task.setExecution(this.replacedBy);
            List<VariableInstanceEntity> variables = commandContext.getVariableInstanceManager().findVariableInstancesByTaskId(task.getId());
            for (VariableInstanceEntity variableInstanceEntity : variables) {
                variableInstanceEntity.setExecution(this.replacedBy);
            }
            this.replacedBy.addTask(task);
        }
        this.tasks.clear();
        List<TaskEntity> tasks = dbEntityManger.getCachedEntitiesByType(TaskEntity.class);
        for (TaskEntity task : tasks) {
            if (!this.id.equals(task.getExecutionId())) continue;
            task.setExecutionId(replacedBy.getId());
        }
        List<JobEntity> jobs = this.getJobs();
        for (JobEntity job : jobs) {
            job.setExecution((ExecutionEntity)replacedBy);
        }
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptions();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            eventSubscriptionEntity.setExecution((ExecutionEntity)replacedBy);
        }
        this.variableStore.ensureVariableInstancesInitialized();
        for (CoreVariableInstance coreVariableInstance : this.variableStore.getVariableInstances().values()) {
            ((VariableInstanceEntity)coreVariableInstance).setExecutionId(replacedBy.getId());
        }
        super.setReplacedBy(replacedBy);
    }

    @Override
    public void replace(PvmExecutionImpl execution) {
        ExecutionEntity replacedExecution = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        for (TaskEntity task : replacedExecution.getTasksInternal()) {
            task.setExecutionId(this.getId());
            task.setExecution(this);
            List<VariableInstanceEntity> variables = commandContext.getVariableInstanceManager().findVariableInstancesByTaskId(task.getId());
            for (VariableInstanceEntity variable : variables) {
                variable.setExecution(this);
            }
            this.addTask(task);
        }
        replacedExecution.getTasksInternal().clear();
        String replacedActivity = replacedExecution.getActivityId();
        if (replacedActivity != null) {
            for (JobEntity job : replacedExecution.getJobs()) {
                if (!replacedActivity.equals(job.getActivityId())) continue;
                replacedExecution.removeJob(job);
                job.setExecution(this);
            }
        }
        super.replace(replacedExecution);
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setProcessInstanceId(this.processInstanceId);
        variableInstance.setExecutionId(this.id);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByExecutionId(this.id);
    }

    protected boolean isAutoFireHistoryEvents() {
        return this.processInstanceStartContext == null && (this.startContext == null || this.startContext != null && !this.startContext.isDelayFireHistoricVariableEvents());
    }

    public void fireHistoricVariableInstanceCreateEvents() {
        Map<String, CoreVariableInstance> variableInstances = this.variableStore.getVariableInstances();
        if (variableInstances != null) {
            for (Map.Entry<String, CoreVariableInstance> variable : variableInstances.entrySet()) {
                this.variableStore.fireHistoricVariableInstanceCreate((VariableInstanceEntity)variable.getValue(), this);
            }
        }
    }

    protected void ensureExecutionTreeInitialized() {
        List<ExecutionEntity> executions = Context.getCommandContext().getExecutionManager().findChildExecutionsByProcessInstanceId(this.processInstanceId);
        ExecutionEntity processInstance = null;
        HashMap<String, ExecutionEntity> executionMap = new HashMap<String, ExecutionEntity>();
        for (ExecutionEntity execution : executions) {
            execution.executions = new ArrayList<ExecutionEntity>();
            executionMap.put(execution.getId(), execution);
            if (!execution.isProcessInstanceExecution()) continue;
            processInstance = execution;
        }
        for (ExecutionEntity execution : executions) {
            String parentId = execution.getParentId();
            ExecutionEntity parent = (ExecutionEntity)executionMap.get(parentId);
            if (!execution.isProcessInstanceExecution()) {
                execution.processInstance = processInstance;
                execution.parent = parent;
                parent.executions.add(execution);
                continue;
            }
            execution.processInstance = execution;
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("activityInstanceId", this.activityInstanceId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("superExecution", this.superExecutionId);
        persistentState.put("superCaseExecutionId", this.superCaseExecutionId);
        persistentState.put("caseInstanceId", this.caseInstanceId);
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("cachedEntityState", this.getCachedEntityState());
        persistentState.put("sequenceCounter", this.getSequenceCounter());
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getExecutionManager().insertExecution(this);
    }

    @Override
    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public void forceUpdate() {
        Context.getCommandContext().getDbEntityManager().forceUpdate(this);
    }

    @Override
    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    public List<EventSubscriptionEntity> getEventSubscriptionsInternal() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    public List<EventSubscriptionEntity> getEventSubscriptions() {
        return new ArrayList<EventSubscriptionEntity>(this.getEventSubscriptionsInternal());
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions() {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity)) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions(String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionManager().findEventSubscriptionsByExecution(this.id);
        }
    }

    public void addEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        List<EventSubscriptionEntity> eventSubscriptionsInternal = this.getEventSubscriptionsInternal();
        if (!eventSubscriptionsInternal.contains(eventSubscriptionEntity)) {
            eventSubscriptionsInternal.add(eventSubscriptionEntity);
        }
    }

    public void removeEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        this.getEventSubscriptionsInternal().remove(eventSubscriptionEntity);
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null) {
            this.jobs = Context.getCommandContext().getJobManager().findJobsByExecutionId(this.id);
        }
    }

    protected List<JobEntity> getJobsInternal() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    public List<JobEntity> getJobs() {
        return new ArrayList<JobEntity>(this.getJobsInternal());
    }

    public void addJob(JobEntity jobEntity) {
        List<JobEntity> jobsInternal = this.getJobsInternal();
        if (!jobsInternal.contains(jobEntity)) {
            jobsInternal.add(jobEntity);
        }
    }

    public void removeJob(JobEntity job) {
        this.getJobsInternal().remove(job);
    }

    protected void ensureIncidentsInitialized() {
        if (this.incidents == null) {
            this.incidents = Context.getCommandContext().getIncidentManager().findIncidentsByExecution(this.id);
        }
    }

    protected List<IncidentEntity> getIncidentsInternal() {
        this.ensureIncidentsInitialized();
        return this.incidents;
    }

    public List<IncidentEntity> getIncidents() {
        return new ArrayList<IncidentEntity>(this.getIncidentsInternal());
    }

    public void addIncident(IncidentEntity incident) {
        List<IncidentEntity> incidentsInternal = this.getIncidentsInternal();
        if (!incidentsInternal.contains(incident)) {
            incidentsInternal.add(incident);
        }
    }

    public void removeIncident(IncidentEntity incident) {
        this.getIncidentsInternal().remove(incident);
    }

    public IncidentEntity getIncidentByCauseIncidentId(String causeIncidentId) {
        for (IncidentEntity incident : this.getIncidents()) {
            if (incident.getCauseIncidentId() == null || !incident.getCauseIncidentId().equals(causeIncidentId)) continue;
            return incident;
        }
        return null;
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskManager().findTasksByExecutionId(this.id);
        }
    }

    protected List<TaskEntity> getTasksInternal() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    public List<TaskEntity> getTasks() {
        return new ArrayList<TaskEntity>(this.getTasksInternal());
    }

    public void addTask(TaskEntity taskEntity) {
        List<TaskEntity> tasksInternal = this.getTasksInternal();
        if (!tasksInternal.contains(taskEntity)) {
            tasksInternal.add(taskEntity);
        }
    }

    public void removeTask(TaskEntity task) {
        this.getTasksInternal().remove(task);
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStore;
    }

    public void setCachedEntityState(int cachedEntityState) {
        this.cachedEntityState = cachedEntityState;
        if (this.jobs == null && !BitMaskUtil.isBitOn(cachedEntityState, 3)) {
            this.jobs = new ArrayList<JobEntity>();
        }
        if (this.tasks == null && !BitMaskUtil.isBitOn(cachedEntityState, 2)) {
            this.tasks = new ArrayList<TaskEntity>();
        }
        if (this.eventSubscriptions == null && !BitMaskUtil.isBitOn(cachedEntityState, 1)) {
            this.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        }
        if (this.incidents == null && !BitMaskUtil.isBitOn(cachedEntityState, 4)) {
            this.incidents = new ArrayList<IncidentEntity>();
        }
        if (this.variableStore.getVariableInstancesWithoutInitialization() == null && !BitMaskUtil.isBitOn(cachedEntityState, 5)) {
            this.variableStore.setVariableInstances(new HashMap<String, VariableInstanceEntity>());
        }
        this.shouldQueryForSubprocessInstance = BitMaskUtil.isBitOn(cachedEntityState, 6);
        this.shouldQueryForSubCaseInstance = BitMaskUtil.isBitOn(cachedEntityState, 7);
    }

    public int getCachedEntityState() {
        this.cachedEntityState = 0;
        Map<String, VariableInstanceEntity> variableInstances = this.variableStore.getVariableInstancesWithoutInitialization();
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 2, this.tasks == null || this.tasks.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 1, this.eventSubscriptions == null || this.eventSubscriptions.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 3, this.jobs == null || this.jobs.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 4, this.incidents == null || this.incidents.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 5, variableInstances == null || variableInstances.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 6, this.shouldQueryForSubprocessInstance);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 7, this.shouldQueryForSubCaseInstance);
        return this.cachedEntityState;
    }

    public int getCachedEntityStateRaw() {
        return this.cachedEntityState;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void setSuperExecutionId(String superExecutionId) {
        this.superExecutionId = superExecutionId;
    }

    @Override
    public boolean hasReferenceTo(DbEntity entity) {
        if (entity instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)entity;
            String otherId = executionEntity.getId();
            if (this.parentId != null && this.parentId.equals(otherId)) {
                return true;
            }
            if (this.superExecutionId != null && this.superExecutionId.equals(otherId)) {
                return true;
            }
        }
        return false;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        if (this.isProcessInstanceExecution() && this.processInstanceStartContext == null) {
            ActivityImpl activity = this.getActivity();
            this.processInstanceStartContext = new HistoryAwareStartContext(activity);
        }
        return this.processInstanceStartContext;
    }

    @Override
    public String getCurrentActivityId() {
        return this.activityId;
    }

    @Override
    public String getCurrentActivityName() {
        return this.activityName;
    }

    @Override
    public FlowElement getBpmnModelElementInstance() {
        BpmnModelInstance bpmnModelInstance = this.getBpmnModelInstance();
        if (bpmnModelInstance != null) {
            ModelElementInstance modelElementInstance = null;
            modelElementInstance = "take".equals(this.eventName) ? bpmnModelInstance.getModelElementById(this.transition.getId()) : bpmnModelInstance.getModelElementById(this.activityId);
            try {
                return (FlowElement)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw new ProcessEngineException("Cannot cast " + modelElementInstance + " to FlowElement. " + "Is of type " + elementType.getTypeName() + " Namespace " + elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance() {
        if (this.processDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }
}

