/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.AuthorizationQueryImpl;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.IncidentQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.VariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class AuthorizationManager
extends AbstractManager {
    public static final String DEFAULT_AUTHORIZATION_CHECK = "defaultAuthorizationCheck";

    public Authorization createNewAuthorization(int type) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        return new AuthorizationEntity(type);
    }

    @Override
    public void insert(DbEntity authorization) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        this.getDbEntityManager().insert(authorization);
    }

    public List<Authorization> selectAuthorizationByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return this.getDbEntityManager().selectList("selectAuthorizationByQueryCriteria", authorizationQuery);
    }

    public Long selectAuthorizationCountByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return (Long)this.getDbEntityManager().selectOne("selectAuthorizationCountByQueryCriteria", authorizationQuery);
    }

    public AuthorizationEntity findAuthorizationByUserIdAndResourceId(int type, String userId, Resource resource, String resourceId) {
        return this.findAuthorization(type, userId, null, resource, resourceId);
    }

    public AuthorizationEntity findAuthorizationByGroupIdAndResourceId(int type, String groupId, Resource resource, String resourceId) {
        return this.findAuthorization(type, null, groupId, resource, resourceId);
    }

    public AuthorizationEntity findAuthorization(int type, String userId, String groupId, Resource resource, String resourceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("userId", userId);
        params.put("groupId", groupId);
        params.put("resourceId", resourceId);
        if (resource != null) {
            params.put("resourceType", resource.resourceType());
        }
        return (AuthorizationEntity)this.getDbEntityManager().selectOne("selectAuthorizationByParameters", params);
    }

    public void update(AuthorizationEntity authorization) {
        this.checkAuthorization(Permissions.UPDATE, Resources.AUTHORIZATION, authorization.getId());
        this.getDbEntityManager().merge(authorization);
    }

    @Override
    public void delete(DbEntity authorization) {
        this.checkAuthorization(Permissions.DELETE, Resources.AUTHORIZATION, authorization.getId());
        this.deleteAuthorizationsByResourceId(Resources.AUTHORIZATION, authorization.getId());
        super.delete(authorization);
    }

    public void checkAuthorization(List<PermissionCheck> permissionChecks) {
        String userId;
        boolean isAuthorized;
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && !(isAuthorized = this.isAuthorized(userId = currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permissionChecks))) {
            if (permissionChecks.size() == 1) {
                PermissionCheck permissionCheck = permissionChecks.get(0);
                String permissionName = permissionCheck.getPermission().getName();
                String resourceType = permissionCheck.getResource().resourceName();
                String resourceId = permissionCheck.getResourceId();
                throw new AuthorizationException(userId, permissionName, resourceType, resourceId);
            }
            String message = "The user with id '" + userId + "' does not have one of the following permissions: ";
            for (int i = 0; i < permissionChecks.size(); ++i) {
                if (i > 0) {
                    message = message + " or ";
                }
                PermissionCheck permissionCheck = permissionChecks.get(i);
                String permissionName = permissionCheck.getPermission().getName();
                String resourceType = permissionCheck.getResource().resourceName();
                String resourceId = permissionCheck.getResourceId();
                message = message + "'" + permissionName + "' permission " + "on resource '" + (resourceId != null ? resourceId + "' of type '" : "") + resourceType + "'";
            }
            throw new AuthorizationException(message);
        }
    }

    public void checkAuthorization(Permission permission, Resource resource) {
        this.checkAuthorization(permission, resource, null);
    }

    @Override
    public void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        boolean isAuthorized;
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && !(isAuthorized = this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId))) {
            throw new AuthorizationException(currentAuthentication.getUserId(), permission.getName(), resource.resourceName(), resourceId);
        }
    }

    public boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId);
        }
        return true;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        PermissionCheck permCheck = new PermissionCheck();
        permCheck.setPermission(permission);
        permCheck.setResource(resource);
        permCheck.setResourceId(resourceId);
        return this.isAuthorized(userId, groupIds, Arrays.asList(permCheck));
    }

    public boolean isAuthorized(String userId, List<String> groupIds, List<PermissionCheck> permissionChecks) {
        AuthorizationCheck authCheck = new AuthorizationCheck();
        authCheck.setAuthUserId(userId);
        authCheck.setAuthGroupIds(groupIds);
        authCheck.setPermissionChecks(permissionChecks);
        return this.getDbEntityManager().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    public void configureQuery(AbstractQuery query) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        query.getPermissionChecks().clear();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            query.setAuthorizationCheckEnabled(true);
            String currentUserId = currentAuthentication.getUserId();
            List<String> currentGroupIds = currentAuthentication.getGroupIds();
            query.setAuthUserId(currentUserId);
            query.setAuthGroupIds(currentGroupIds);
        } else {
            query.setAuthorizationCheckEnabled(false);
            query.setAuthUserId(null);
            query.setAuthGroupIds(null);
        }
    }

    public void configureQuery(AbstractQuery query, Resource resource) {
        this.configureQuery(query, resource, "RES.ID_");
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam) {
        this.configureQuery(query, resource, queryParam, Permissions.READ);
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam, Permission permission) {
        this.configureQuery(query);
        this.addAuthorizationCheckParameter(query, resource, queryParam, permission);
    }

    protected void addAuthorizationCheckParameter(AbstractQuery query, Resource resource, String queryParam, Permission permission) {
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceIdQueryParam(queryParam);
            permCheck.setPermission(permission);
            query.addPermissionCheck(permCheck);
        }
    }

    public void deleteAuthorizationsByResourceId(Resource resource, String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceId", deleteParams);
        }
    }

    public void checkReadProcessDefinition(ProcessDefinitionEntity definition) {
        this.checkReadProcessDefinition(definition.getKey());
    }

    public void checkReadProcessDefinition(String processDefinitionKey) {
        this.checkAuthorization(Permissions.READ, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    public void checkUpdateProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        String processDefinitionKey = definition.getKey();
        this.checkUpdateProcessDefinitionByKey(processDefinitionKey);
    }

    public void checkUpdateProcessDefinitionByKey(String processDefinitionKey) {
        this.checkAuthorization(Permissions.UPDATE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    public void checkCreateProcessInstance(ProcessDefinitionEntity definition) {
        this.checkAuthorization(Permissions.CREATE, Resources.PROCESS_INSTANCE);
        this.checkAuthorization(Permissions.CREATE_INSTANCE, Resources.PROCESS_DEFINITION, definition.getKey());
    }

    public void checkReadProcessInstance(String processInstanceId) {
        ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkReadProcessInstance(execution);
        }
    }

    public void checkReadProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.READ);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.READ_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(Arrays.asList(firstCheck, secondCheck));
    }

    public void checkUpdateProcessInstanceById(String processInstanceId) {
        ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkUpdateProcessInstance(execution);
        }
    }

    public void checkUpdateProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(Arrays.asList(firstCheck, secondCheck));
    }

    public void checkUpdateInstanceOnProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        if (definition != null) {
            String processDefinitionKey = definition.getKey();
            this.checkUpdateInstanceOnProcessDefinitionByKey(processDefinitionKey);
        }
    }

    public void checkUpdateInstanceOnProcessDefinitionByKey(String processDefinitionKey) {
        this.checkAuthorization(Permissions.UPDATE_INSTANCE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    public void checkDeleteProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.DELETE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.DELETE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(Arrays.asList(firstCheck, secondCheck));
    }

    public void checkCreateTask() {
        this.checkAuthorization(Permissions.CREATE, Resources.TASK);
    }

    public void checkReadTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
            PermissionCheck readPermissionCheck = new PermissionCheck();
            readPermissionCheck.setPermission(Permissions.READ);
            readPermissionCheck.setResource(Resources.TASK);
            readPermissionCheck.setResourceId(taskId);
            PermissionCheck readTaskPermissionCheck = new PermissionCheck();
            readTaskPermissionCheck.setPermission(Permissions.READ_TASK);
            readTaskPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            readTaskPermissionCheck.setResourceId(processDefinition.getKey());
            readTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            this.checkAuthorization(Arrays.asList(readPermissionCheck, readTaskPermissionCheck));
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.checkAuthorization(Permissions.READ, Resources.TASK, taskId);
            }
        }
    }

    public void checkUpdateTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
            PermissionCheck updatePermissionCheck = new PermissionCheck();
            updatePermissionCheck.setPermission(Permissions.UPDATE);
            updatePermissionCheck.setResource(Resources.TASK);
            updatePermissionCheck.setResourceId(taskId);
            PermissionCheck updateTaskPermissionCheck = new PermissionCheck();
            updateTaskPermissionCheck.setPermission(Permissions.UPDATE_TASK);
            updateTaskPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            updateTaskPermissionCheck.setResourceId(processDefinition.getKey());
            updateTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            this.checkAuthorization(Arrays.asList(updatePermissionCheck, updateTaskPermissionCheck));
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.checkAuthorization(Permissions.UPDATE, Resources.TASK, taskId);
            }
        }
    }

    public void checkDeleteTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        String caseExecutionId = task.getCaseExecutionId();
        if (executionId == null && caseExecutionId == null) {
            this.checkAuthorization(Permissions.DELETE, Resources.TASK, taskId);
        }
    }

    public void configureProcessDefinitionQuery(ProcessDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.KEY_");
    }

    public void configureExecutionQuery(AbstractQuery query) {
        this.configureQuery(query);
        this.addAuthorizationCheckParameter(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addAuthorizationCheckParameter(query, Resources.PROCESS_DEFINITION, "P.KEY_", Permissions.READ_INSTANCE);
    }

    public void configureTaskQuery(TaskQueryImpl query) {
        query.getPermissionChecks().clear();
        query.getTaskPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            this.configureQuery(query);
            this.addAuthorizationCheckParameter(query, Resources.TASK, "RES.ID_", Permissions.READ);
            this.addAuthorizationCheckParameter(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_TASK);
            PermissionCheck standaloneTaskPermissionCheck = new PermissionCheck();
            standaloneTaskPermissionCheck.setPermission(Permissions.READ);
            standaloneTaskPermissionCheck.setResource(Resources.TASK);
            standaloneTaskPermissionCheck.setResourceIdQueryParam("RES.ID_");
            standaloneTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addTaskPermissionCheck(standaloneTaskPermissionCheck);
        }
    }

    public void configureEventSubscriptionQuery(EventSubscriptionQueryImpl query) {
        this.configureQuery(query);
        this.addAuthorizationCheckParameter(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addAuthorizationCheckParameter(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
    }

    public void configureIncidentQuery(IncidentQueryImpl query) {
        this.configureQuery(query);
        this.addAuthorizationCheckParameter(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addAuthorizationCheckParameter(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
    }

    protected void configureVariableInstanceQuery(VariableInstanceQueryImpl query) {
        query.getPermissionChecks().clear();
        query.getTaskPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            this.configureQuery(query);
            this.addAuthorizationCheckParameter(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
            this.addAuthorizationCheckParameter(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
            PermissionCheck taskPermissionCheck = new PermissionCheck();
            taskPermissionCheck.setResource(Resources.TASK);
            taskPermissionCheck.setPermission(Permissions.READ);
            taskPermissionCheck.setResourceIdQueryParam("RES.TASK_ID_");
            taskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addTaskPermissionCheck(taskPermissionCheck);
        }
    }

    public void configureProcessDefinitionStatisticsQuery(ProcessDefinitionStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_");
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        PermissionCheck firstProcessInstancePermissionCheck = new PermissionCheck();
        firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
        firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
        firstProcessInstancePermissionCheck.setResourceIdQueryParam("E.PROC_INST_ID_");
        PermissionCheck secondProcessInstancePermissionCheck = new PermissionCheck();
        secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
        secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
        secondProcessInstancePermissionCheck.setResourceIdQueryParam("P.KEY_");
        secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
        query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
        query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
        if (query.isFailedJobsToInclude()) {
            PermissionCheck firstJobPermissionCheck = new PermissionCheck();
            firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstJobPermissionCheck.setPermission(Permissions.READ);
            firstJobPermissionCheck.setResourceIdQueryParam("PROCESS_INSTANCE_ID_");
            PermissionCheck secondJobPermissionCheck = new PermissionCheck();
            secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondJobPermissionCheck.setResourceIdQueryParam("PROCESS_DEF_KEY_");
            secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addJobPermissionCheck(firstJobPermissionCheck);
            query.addJobPermissionCheck(secondJobPermissionCheck);
        }
        if (query.isIncidentsToInclude()) {
            PermissionCheck firstIncidentPermissionCheck = new PermissionCheck();
            firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstIncidentPermissionCheck.setPermission(Permissions.READ);
            firstIncidentPermissionCheck.setResourceIdQueryParam("I.PROC_INST_ID_");
            PermissionCheck secondIncidentPermissionCheck = new PermissionCheck();
            secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
            secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
            query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
        }
    }

    public void configureActivityStatisticsQuery(ActivityStatisticsQueryImpl query) {
        this.configureQuery(query);
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        PermissionCheck firstProcessInstancePermissionCheck = new PermissionCheck();
        firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
        firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
        firstProcessInstancePermissionCheck.setResourceIdQueryParam("E.PROC_INST_ID_");
        PermissionCheck secondProcessInstancePermissionCheck = new PermissionCheck();
        secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
        secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
        secondProcessInstancePermissionCheck.setResourceIdQueryParam("P.KEY_");
        secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
        query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
        query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
        if (query.isFailedJobsToInclude()) {
            PermissionCheck firstJobPermissionCheck = new PermissionCheck();
            firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstJobPermissionCheck.setPermission(Permissions.READ);
            firstJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_INSTANCE_ID_");
            PermissionCheck secondJobPermissionCheck = new PermissionCheck();
            secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_DEF_KEY_");
            secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addJobPermissionCheck(firstJobPermissionCheck);
            query.addJobPermissionCheck(secondJobPermissionCheck);
        }
        if (query.isIncidentsToInclude()) {
            PermissionCheck firstIncidentPermissionCheck = new PermissionCheck();
            firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstIncidentPermissionCheck.setPermission(Permissions.READ);
            firstIncidentPermissionCheck.setResourceIdQueryParam("I.PROC_INST_ID_");
            PermissionCheck secondIncidentPermissionCheck = new PermissionCheck();
            secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
            secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
            query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
        }
    }
}

