/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.GetUnlockedTimersByDuedateCmd;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class AcquireJobsRunnable
implements Runnable {
    private static Logger log = Logger.getLogger(AcquireJobsRunnable.class.getName());
    protected final JobExecutor jobExecutor;
    protected volatile boolean isInterrupted = false;
    protected volatile boolean isJobAdded = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);
    protected long millisToWait = 0L;
    protected float waitIncreaseFactor = 2.0f;
    protected long maxWait = 60000L;

    public AcquireJobsRunnable(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.jobExecutor.getName() + " starting to acquire jobs");
        }
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        while (!this.isInterrupted) {
            block21: {
                int maxJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
                try {
                    AcquiredJobs acquiredJobs = commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd());
                    for (List<String> jobIds : acquiredJobs.getJobIdBatches()) {
                        this.jobExecutor.executeJobs(jobIds);
                    }
                    this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
                    int jobsAcquired = acquiredJobs.getJobIdBatches().size() + acquiredJobs.getNumberOfJobsFailedToLock();
                    if (jobsAcquired < maxJobsPerAcquisition) {
                        long millisTillNextTimer;
                        this.isJobAdded = false;
                        Date duedate = new Date(ClockUtil.getCurrentTime().getTime() + this.millisToWait);
                        List<TimerEntity> nextTimers = commandExecutor.execute(new GetUnlockedTimersByDuedateCmd(duedate, new Page(0, 1)));
                        if (!nextTimers.isEmpty() && (millisTillNextTimer = nextTimers.get(0).getDuedate().getTime() - ClockUtil.getCurrentTime().getTime()) < this.millisToWait) {
                            this.millisToWait = millisTillNextTimer;
                        }
                    } else {
                        this.millisToWait = 0L;
                    }
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "exception during job acquisition: " + e.getMessage(), e);
                    }
                    this.millisToWait = (long)((float)this.millisToWait * this.waitIncreaseFactor);
                    if (this.millisToWait > this.maxWait) {
                        this.millisToWait = this.maxWait;
                    }
                    if (this.millisToWait != 0L) break block21;
                    this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
                }
            }
            if (this.millisToWait <= 0L || this.isJobAdded) continue;
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("job acquisition thread sleeping for " + this.millisToWait + " millis");
                }
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.millisToWait);
                    }
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("job acquisition thread woke up");
            }
            catch (InterruptedException e) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("job acquisition wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(this.jobExecutor.getName() + " stopped job acquisition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                this.MONITOR.notifyAll();
            }
        }
    }

    public long getMillisToWait() {
        return this.millisToWait;
    }

    public void setMillisToWait(long millisToWait) {
        this.millisToWait = millisToWait;
    }

    public float getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public void setWaitIncreaseFactor(float waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }
}

