/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormFieldValidationConstraint;
import org.camunda.bpm.engine.form.FormType;
import org.camunda.bpm.engine.impl.el.StartProcessVariableScope;
import org.camunda.bpm.engine.impl.form.FormFieldImpl;
import org.camunda.bpm.engine.impl.form.handler.FormFieldValidationConstraintHandler;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class FormFieldHandler {
    protected String id;
    protected Expression label;
    protected AbstractFormFieldType type;
    protected Expression defaultValueExpression;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected List<FormFieldValidationConstraintHandler> validationHandlers = new ArrayList<FormFieldValidationConstraintHandler>();

    public FormField createFormField(ExecutionEntity executionEntity) {
        Object value;
        FormFieldImpl formField = new FormFieldImpl();
        formField.setId(this.id);
        VariableScope variableScope = executionEntity != null ? executionEntity : StartProcessVariableScope.getSharedInstance();
        Object labelValueObject = this.label.getValue(variableScope);
        if (labelValueObject != null) {
            formField.setLabel(labelValueObject.toString());
        }
        formField.setType(this.type);
        Object defaultValue = null;
        if (this.defaultValueExpression != null) {
            defaultValue = this.defaultValueExpression.getValue(variableScope);
            if (defaultValue != null) {
                formField.setDefaultValue(this.type.convertFormValueToModelValue(defaultValue));
            } else {
                formField.setDefaultValue(null);
            }
        }
        if ((value = variableScope.getVariableTyped(this.id)) != null) {
            formField.setValue(this.type.convertToFormValue((TypedValue)value));
        } else {
            TypedValue typedDefaultValue = this.type.convertToModelValue(Variables.untypedValue(defaultValue));
            formField.setValue(this.type.convertToFormValue(typedDefaultValue));
        }
        formField.setProperties(this.properties);
        List<FormFieldValidationConstraint> validationConstraints = formField.getValidationConstraints();
        for (FormFieldValidationConstraintHandler validationHandler : this.validationHandlers) {
            if ("validator".equals(validationHandler.name)) continue;
            validationConstraints.add(validationHandler.createValidationConstraint(executionEntity));
        }
        return formField;
    }

    public void handleSubmit(VariableScope variableScope, VariableMap values, VariableMap allValues) {
        Object submittedValue = values.getValueTyped(this.id);
        values.remove(this.id);
        for (FormFieldValidationConstraintHandler validationHandler : this.validationHandlers) {
            Object value = null;
            if (submittedValue != null) {
                value = submittedValue.getValue();
            }
            validationHandler.validate(value, allValues, this, variableScope);
        }
        TypedValue modelValue = null;
        if (submittedValue != null) {
            modelValue = this.type != null ? this.type.convertToModelValue((TypedValue)submittedValue) : (TypedValue)submittedValue;
        } else if (this.defaultValueExpression != null) {
            TypedValue expressionValue = Variables.untypedValue(this.defaultValueExpression.getValue(variableScope));
            if (this.type != null) {
                modelValue = this.type.convertToModelValue(Variables.untypedValue(expressionValue));
            } else if (expressionValue != null) {
                modelValue = Variables.stringValue(expressionValue.getValue().toString());
            }
        }
        if (modelValue != null && this.id != null) {
            variableScope.setVariable(this.id, modelValue);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression name) {
        this.label = name;
    }

    public void setType(AbstractFormFieldType formType) {
        this.type = formType;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public FormType getType() {
        return this.type;
    }

    public Expression getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    public void setDefaultValueExpression(Expression defaultValue) {
        this.defaultValueExpression = defaultValue;
    }

    public List<FormFieldValidationConstraintHandler> getValidationHandlers() {
        return this.validationHandlers;
    }

    public void setValidationHandlers(List<FormFieldValidationConstraintHandler> validationHandlers) {
        this.validationHandlers = validationHandlers;
    }
}

