/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.WrongDbException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.HistoryLevel;

public abstract class AbstractPersistenceSession
implements PersistenceSession {
    @Override
    public void executeDbOperation(DbOperation operation) {
        switch (operation.getOperationType()) {
            case INSERT: {
                this.insertEntity((DbEntityOperation)operation);
                break;
            }
            case DELETE: {
                this.deleteEntity((DbEntityOperation)operation);
                break;
            }
            case DELETE_BULK: {
                this.deleteBulk((DbBulkOperation)operation);
                break;
            }
            case UPDATE: {
                this.updateEntity((DbEntityOperation)operation);
                break;
            }
            case UPDATE_BULK: {
                this.updateBulk((DbBulkOperation)operation);
            }
        }
    }

    protected abstract void insertEntity(DbEntityOperation var1);

    protected abstract void deleteEntity(DbEntityOperation var1);

    protected abstract void deleteBulk(DbBulkOperation var1);

    protected abstract void updateEntity(DbEntityOperation var1);

    protected abstract void updateBulk(DbBulkOperation var1);

    protected abstract String getDbVersion();

    @Override
    public void dbSchemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (!processEngineConfiguration.isDbHistoryUsed() && !configuredHistoryLevel.equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            throw new ProcessEngineException("historyLevel config is higher then 'none' and dbHistoryUsed is set to false");
        }
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw new WrongDbException("fox", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        if (processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmn();
        }
        if (processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateCmmnHistory();
        }
    }

    protected abstract void dbSchemaCreateIdentity();

    protected abstract void dbSchemaCreateHistory();

    protected abstract void dbSchemaCreateEngine();

    protected abstract void dbSchemaCreateCmmn();

    protected abstract void dbSchemaCreateCmmnHistory();

    @Override
    public void dbSchemaDrop() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaDropCmmn();
        }
        this.dbSchemaDropEngine();
        if (processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropCmmnHistory();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaDropIdentity();
        }
    }

    protected abstract void dbSchemaDropIdentity();

    protected abstract void dbSchemaDropHistory();

    protected abstract void dbSchemaDropEngine();

    protected abstract void dbSchemaDropCmmn();

    protected abstract void dbSchemaDropCmmnHistory();

    @Override
    public void dbSchemaPrune() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (this.isHistoryTablePresent() && !processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropHistory();
        }
        if (this.isIdentityTablePresent() && !processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaDropIdentity();
        }
        if (this.isCmmnTablePresent() && !processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaDropCmmn();
        }
        if (this.isCmmnHistoryTablePresent() && !processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmnHistory();
        }
    }

    public abstract boolean isEngineTablePresent();

    public abstract boolean isHistoryTablePresent();

    public abstract boolean isIdentityTablePresent();

    public abstract boolean isCmmnTablePresent();

    public abstract boolean isCmmnHistoryTablePresent();

    @Override
    public void dbSchemaUpdate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (!this.isEngineTablePresent()) {
            this.dbSchemaCreateEngine();
        }
        if (!this.isHistoryTablePresent() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (!this.isIdentityTablePresent() && processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        if (!this.isCmmnTablePresent() && processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmn();
        }
        if (!this.isCmmnHistoryTablePresent() && processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateCmmnHistory();
        }
    }
}

