/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.value;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.core.variable.value.AbstractTypedValue;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;

public class ObjectValueImpl
extends AbstractTypedValue<Object>
implements ObjectValue {
    private static final long serialVersionUID = 1L;
    protected String objectTypeName;
    protected String serializationDataFormat;
    protected String serializedValue;
    protected boolean isDeserialized;

    public ObjectValueImpl(Object deserializedValue, String serializedValue, String serializationDataFormat, String objectTypeName, boolean isDeserialized) {
        super(deserializedValue, ValueType.OBJECT);
        this.serializedValue = serializedValue;
        this.serializationDataFormat = serializationDataFormat;
        this.objectTypeName = objectTypeName;
        this.isDeserialized = isDeserialized;
    }

    public ObjectValueImpl(Object value) {
        this(value, null, null, null, true);
    }

    @Override
    public String getSerializationDataFormat() {
        return this.serializationDataFormat;
    }

    public void setSerializationDataFormat(String serializationDataFormat) {
        this.serializationDataFormat = serializationDataFormat;
    }

    @Override
    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    @Override
    public String getValueSerialized() {
        return this.serializedValue;
    }

    public void setSerializedValue(String serializedValue) {
        this.serializedValue = serializedValue;
    }

    @Override
    public boolean isDeserialized() {
        return this.isDeserialized;
    }

    @Override
    public Object getValue() {
        if (this.isDeserialized) {
            return super.getValue();
        }
        throw new IllegalStateException("Object is not deserialized.");
    }

    @Override
    public <T> T getValue(Class<T> type) {
        Object value = this.getValue();
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new ProcessEngineException("Value '" + value + "' is not of type '" + type + "'.");
    }

    @Override
    public Class<?> getObjectType() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getClass();
    }

    @Override
    public SerializableValueType getType() {
        return (SerializableValueType)super.getType();
    }

    @Override
    public String toString() {
        return "ObjectValue [value=" + this.value + ", isDeserialized=" + this.isDeserialized + ", serializationDataFormat=" + this.serializationDataFormat + ", objectTypeName=" + this.objectTypeName + ", serializedValue=" + (this.serializedValue != null ? this.serializedValue.length() + " chars" : null) + "]";
    }
}

