/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class SetJobRetriesCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String RETRIES = "retries";
    protected final String jobId;
    protected final String jobDefinitionId;
    protected final int retries;

    public SetJobRetriesCmd(String jobId, String jobDefinitionId, int retries) {
        if ((jobId == null || jobId.isEmpty()) && (jobDefinitionId == null || jobDefinitionId.isEmpty())) {
            throw new ProcessEngineException("Either job definition id or job id has to be provided as parameter.");
        }
        if (retries < 0) {
            throw new ProcessEngineException("The number of job retries must be a non-negative Integer, but '" + retries + "' has been provided.");
        }
        this.jobId = jobId;
        this.jobDefinitionId = jobDefinitionId;
        this.retries = retries;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.jobId != null) {
            this.setJobRetriesByJobId(commandContext);
        } else {
            this.setJobRetriesByJobDefinitionId(commandContext);
        }
        return null;
    }

    protected void setJobRetriesByJobId(CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        if (job != null) {
            if (job.isInInconsistentLockState()) {
                job.resetLock();
            }
        } else {
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'.");
        }
        int oldRetries = job.getRetries();
        job.setRetries(this.retries);
        PropertyChange propertyChange = new PropertyChange(RETRIES, oldRetries, job.getRetries());
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), job.getId(), job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), propertyChange);
    }

    protected void setJobRetriesByJobDefinitionId(CommandContext commandContext) {
        commandContext.getJobManager().updateFailedJobRetriesByJobDefinitionId(this.jobDefinitionId, this.retries);
        PropertyChange propertyChange = new PropertyChange(RETRIES, null, this.retries);
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), null, this.jobDefinitionId, null, null, null, propertyChange);
    }

    protected String getLogEntryOperation() {
        return "SetJobRetries";
    }
}

