/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import org.camunda.bpm.engine.impl.cmd.AbstractRemoveVariableCmd;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class RemoveExecutionVariablesCmd
extends AbstractRemoveVariableCmd {
    private static final long serialVersionUID = 1L;

    public RemoveExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        super(executionId, variableNames, isLocal);
    }

    @Override
    protected ExecutionEntity getEntity() {
        EnsureUtil.ensureNotNull("executionId", (Object)this.entityId);
        ExecutionEntity execution = this.commandContext.getExecutionManager().findExecutionById(this.entityId);
        EnsureUtil.ensureNotNull("execution " + this.entityId + " doesn't exist", "execution", (Object)execution);
        return execution;
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        ExecutionEntity execution = (ExecutionEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), execution, PropertyChange.EMPTY_CHANGE);
    }
}

