/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class MessageEventReceivedCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String executionId;
    protected final Map<String, Object> processVariables;
    protected final String messageName;

    public MessageEventReceivedCmd(String messageName, String executionId, Map<String, Object> processVariables) {
        this.executionId = executionId;
        this.messageName = messageName;
        this.processVariables = processVariables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("executionId", (Object)this.executionId);
        final EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        Callable<List<EventSubscriptionEntity>> callableWithoutAuthoriatzion = null;
        callableWithoutAuthoriatzion = this.messageName != null ? new Callable<List<EventSubscriptionEntity>>(){

            @Override
            public List<EventSubscriptionEntity> call() throws Exception {
                return eventSubscriptionManager.findEventSubscriptionsByNameAndExecution("message", MessageEventReceivedCmd.this.messageName, MessageEventReceivedCmd.this.executionId);
            }
        } : new Callable<List<EventSubscriptionEntity>>(){

            @Override
            public List<EventSubscriptionEntity> call() throws Exception {
                return eventSubscriptionManager.findEventSubscriptionsByExecutionAndType(MessageEventReceivedCmd.this.executionId, "message");
            }
        };
        List<EventSubscriptionEntity> eventSubscriptions = commandContext.runWithoutAuthentication(callableWithoutAuthoriatzion);
        EnsureUtil.ensureNotEmpty("Execution with id '" + this.executionId + "' does not have a subscription to a message event with name '" + this.messageName + "'", "eventSubscriptions", eventSubscriptions);
        EnsureUtil.ensureNumberOfElements("More than one matching message subscription found for execution " + this.executionId, "eventSubscriptions", eventSubscriptions, 1);
        EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptions.get(0);
        String processInstanceId = eventSubscriptionEntity.getProcessInstanceId();
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstanceById(processInstanceId);
        HashMap<String, Object> payload = null;
        if (this.processVariables != null) {
            payload = new HashMap<String, Object>(this.processVariables);
        }
        eventSubscriptionEntity.eventReceived(payload, false);
        return null;
    }
}

