/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import org.camunda.bpm.engine.impl.cmd.GetStartFormCmd;
import org.camunda.bpm.engine.impl.core.variable.VariableMapImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.variable.VariableMap;

public class GetStartFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    private static final long serialVersionUID = 1L;

    public GetStartFormVariablesCmd(String resourceId, Collection<String> formVariableNames, boolean deserializeObjectValues) {
        super(resourceId, formVariableNames, deserializeObjectValues);
    }

    @Override
    public VariableMap execute(final CommandContext commandContext) {
        StartFormData startFormData = commandContext.runWithoutAuthentication(new Callable<StartFormData>(){

            @Override
            public StartFormData call() throws Exception {
                return new GetStartFormCmd(GetStartFormVariablesCmd.this.resourceId).execute(commandContext);
            }
        });
        ProcessDefinition definition = startFormData.getProcessDefinition();
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadProcessDefinition((ProcessDefinitionEntity)definition);
        VariableMapImpl result = new VariableMapImpl();
        for (FormField formField : startFormData.getFormFields()) {
            if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
            result.put(formField.getId(), this.createVariable(formField, null));
        }
        return result;
    }
}

