/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetStartFormCmd
implements Command<StartFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetStartFormCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public StartFormData execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        final DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = commandContext.runWithoutAuthentication(new Callable<ProcessDefinitionEntity>(){

            @Override
            public ProcessDefinitionEntity call() throws Exception {
                return deploymentCache.findDeployedProcessDefinitionById(GetStartFormCmd.this.processDefinitionId);
            }
        });
        EnsureUtil.ensureNotNull("No process definition found for id '" + this.processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadProcessDefinition(processDefinition);
        StartFormHandler startFormHandler = processDefinition.getStartFormHandler();
        EnsureUtil.ensureNotNull("No startFormHandler defined in process '" + this.processDefinitionId + "'", "startFormHandler", (Object)startFormHandler);
        return startFormHandler.createStartFormData(processDefinition);
    }
}

