/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.DefaultStartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;

public class GetFormKeyCmd
implements Command<String> {
    protected String taskDefinitionKey;
    protected String processDefinitionId;

    public GetFormKeyCmd(String processDefinitionId) {
        this.setProcessDefinitionId(processDefinitionId);
    }

    public GetFormKeyCmd(String processDefinitionId, String taskDefinitionKey) {
        this.setProcessDefinitionId(processDefinitionId);
        if (taskDefinitionKey == null || taskDefinitionKey.length() < 1) {
            throw new ProcessEngineException("The task definition key is mandatory, but '" + taskDefinitionKey + "' has been provided.");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }

    protected void setProcessDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        final DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = commandContext.runWithoutAuthentication(new Callable<ProcessDefinitionEntity>(){

            @Override
            public ProcessDefinitionEntity call() throws Exception {
                return deploymentCache.findDeployedProcessDefinitionById(GetFormKeyCmd.this.processDefinitionId);
            }
        });
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadProcessDefinition(processDefinition);
        Expression formKeyExpression = null;
        if (this.taskDefinitionKey == null) {
            StartFormHandler formHandler = processDefinition.getStartFormHandler();
            if (formHandler instanceof DefaultStartFormHandler) {
                DefaultStartFormHandler startFormHandler = (DefaultStartFormHandler)formHandler;
                formKeyExpression = startFormHandler.getFormKey();
            }
        } else {
            TaskDefinition taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
            formKeyExpression = taskDefinition.getFormKey();
        }
        String formKey = null;
        if (formKeyExpression != null) {
            formKey = formKeyExpression.getExpressionText();
        }
        return formKey;
    }
}

