/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;

public class DeleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> taskIds;
    protected boolean cascade;
    protected String deleteReason;

    public DeleteTaskCmd(String taskId, String deleteReason, boolean cascade) {
        this.taskId = taskId;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    public DeleteTaskCmd(Collection<String> taskIds, String deleteReason, boolean cascade) {
        this.taskIds = taskIds;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.deleteTask(this.taskId, commandContext);
        } else if (this.taskIds != null) {
            for (String taskId : this.taskIds) {
                this.deleteTask(taskId, commandContext);
            }
        } else {
            throw new ProcessEngineException("taskId and taskIds are null");
        }
        return null;
    }

    protected void deleteTask(final String taskId, CommandContext commandContext) {
        final TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = commandContext.runWithoutAuthentication(new Callable<TaskEntity>(){

            @Override
            public TaskEntity call() throws Exception {
                return taskManager.findTaskById(taskId);
            }
        });
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running process");
            }
            if (task.getCaseExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running case instance");
            }
            AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
            authorizationManager.checkDeleteTask(task);
            String reason = this.deleteReason == null || this.deleteReason.length() == 0 ? "deleted" : this.deleteReason;
            task.delete(reason, this.cascade);
        } else if (this.cascade) {
            Context.getCommandContext().getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
        }
    }
}

