/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteProcessInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String deleteReason;
    protected boolean skipCustomListeners;

    public DeleteProcessInstanceCmd(String processInstanceId, String deleteReason, boolean skipCustomListeners) {
        this.processInstanceId = processInstanceId;
        this.deleteReason = deleteReason;
        this.skipCustomListeners = skipCustomListeners;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceId", (Object)this.processInstanceId);
        final ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = commandContext.runWithoutAuthentication(new Callable<ExecutionEntity>(){

            @Override
            public ExecutionEntity call() throws Exception {
                return executionManager.findExecutionById(DeleteProcessInstanceCmd.this.processInstanceId);
            }
        });
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "No process instance found for id '" + this.processInstanceId + "'", "processInstance", (Object)execution);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkDeleteProcessInstance(execution);
        commandContext.getExecutionManager().deleteProcessInstance(this.processInstanceId, this.deleteReason, false, this.skipCustomListeners);
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", this.processInstanceId, null, null, PropertyChange.EMPTY_CHANGE);
        return null;
    }
}

