/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeleteDeploymentFailListener;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteDeploymentCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DeleteDeploymentCmd.class.getName());
    protected String deploymentId;
    protected boolean cascade;
    protected boolean skipCustomListeners;

    public DeleteDeploymentCmd(String deploymentId, boolean cascade, boolean skipCustomListeners) {
        this.deploymentId = deploymentId;
        this.cascade = cascade;
        this.skipCustomListeners = skipCustomListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        commandContext.getDeploymentManager().deleteDeployment(this.deploymentId, this.cascade, this.skipCustomListeners);
        DeleteDeploymentFailListener listener = new DeleteDeploymentFailListener(this.deploymentId);
        try {
            new UnregisterDeploymentCmd(Collections.singleton(this.deploymentId)).execute(commandContext);
        }
        finally {
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not register transaction synchronization. Probably the TX has already been rolled back by application code.", e);
                listener.execute(commandContext);
            }
        }
        return null;
    }
}

