/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ClaimTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String userId;

    public ClaimTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        final TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = commandContext.runWithoutAuthentication(new Callable<TaskEntity>(){

            @Override
            public TaskEntity call() throws Exception {
                return taskManager.findTaskById(ClaimTaskCmd.this.taskId);
            }
        });
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateTask(task);
        if (this.userId != null) {
            if (task.getAssignee() != null) {
                if (!task.getAssignee().equals(this.userId)) {
                    throw new TaskAlreadyClaimedException(task.getId(), task.getAssignee());
                }
            } else {
                task.setAssignee(this.userId);
            }
        } else {
            task.setAssignee(null);
        }
        task.createHistoricTaskDetails("Claim");
        return null;
    }
}

