/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerChangeJobDefinitionSuspensionStateJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;

public abstract class AbstractSetJobDefinitionStateCmd
extends AbstractSetStateCmd {
    protected String jobDefinitionId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected Date executionDate;

    public AbstractSetJobDefinitionStateCmd(String jobDefinitionId, String processDefinitionId, String processDefinitionKey, boolean includeJobs, Date executionDate) {
        super(includeJobs, executionDate);
        this.jobDefinitionId = jobDefinitionId;
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.executionDate = executionDate;
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.jobDefinitionId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Job definition id, process definition id nor process definition key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.jobDefinitionId != null) {
            final JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
            JobDefinitionEntity jobDefinition = commandContext.runWithoutAuthentication(new Callable<JobDefinitionEntity>(){

                @Override
                public JobDefinitionEntity call() throws Exception {
                    return jobDefinitionManager.findById(AbstractSetJobDefinitionStateCmd.this.jobDefinitionId);
                }
            });
            if (jobDefinition != null) {
                String processDefinitionKey = jobDefinition.getProcessDefinitionKey();
                authorizationManager.checkUpdateProcessDefinitionByKey(processDefinitionKey);
                if (this.includeSubResources) {
                    authorizationManager.checkUpdateInstanceOnProcessDefinitionByKey(processDefinitionKey);
                }
            }
        } else if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateProcessDefinitionById(this.processDefinitionId);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateInstanceOnProcessDefinitionById(this.processDefinitionId);
            }
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateProcessDefinitionByKey(this.processDefinitionKey);
            if (this.includeSubResources) {
                authorizationManager.checkUpdateInstanceOnProcessDefinitionByKey(this.processDefinitionKey);
            }
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        JobManager jobManager = commandContext.getJobManager();
        if (this.jobDefinitionId != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateById(this.jobDefinitionId, suspensionState);
        } else if (this.processDefinitionId != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            jobManager.updateStartTimerJobSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            jobDefinitionManager.updateJobDefinitionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            jobManager.updateStartTimerJobSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
    }

    @Override
    protected String getJobHandlerConfiguration() {
        String jobConfiguration = null;
        if (this.jobDefinitionId != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByJobDefinitionId(this.jobDefinitionId, this.isIncludeSubResources());
        } else if (this.processDefinitionId != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionId(this.processDefinitionId, this.isIncludeSubResources());
        } else if (this.processDefinitionKey != null) {
            jobConfiguration = TimerChangeJobDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKey(this.processDefinitionKey, this.isIncludeSubResources());
        }
        return jobConfiguration;
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logJobDefinitionOperation(this.getLogEntryOperation(), this.jobDefinitionId, this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }

    @Override
    protected abstract String getDelayedExecutionJobHandlerType();

    @Override
    protected abstract AbstractSetJobStateCmd getNextCommand();
}

