/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ActivityExecutionMapping;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.core.variable.VariableMapImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.tree.ActivityStackCollector;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.TreeWalker;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.variable.VariableMap;

public abstract class AbstractInstantiationCmd
extends AbstractProcessInstanceModificationCommand {
    protected VariableMap variables;
    protected VariableMap variablesLocal;
    protected String ancestorActivityInstanceId;

    public AbstractInstantiationCmd(String processInstanceId, String ancestorActivityInstanceId) {
        super(processInstanceId);
        this.ancestorActivityInstanceId = ancestorActivityInstanceId;
        this.variables = new VariableMapImpl();
        this.variablesLocal = new VariableMapImpl();
    }

    public void addVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public void addVariableLocal(String name, Object value) {
        this.variablesLocal.put(name, value);
    }

    public void addVariables(Map<String, Object> variables) {
        this.variables.putAll(variables);
    }

    public void addVariablesLocal(Map<String, Object> variables) {
        this.variablesLocal.putAll(variables);
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public VariableMap getVariablesLocal() {
        return this.variablesLocal;
    }

    @Override
    public Void execute(final CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        final ProcessDefinitionImpl processDefinition = processInstance.getProcessDefinition();
        CoreModelElement elementToInstantiate = this.getTargetElement(processDefinition);
        EnsureUtil.ensureNotNull("element", (Object)elementToInstantiate);
        final ActivityExecutionMapping mapping = new ActivityExecutionMapping(commandContext, this.processInstanceId);
        ScopeImpl flowScope = this.getTargetFlowScope(processDefinition);
        ActivityStackCollector stackCollector = new ActivityStackCollector();
        FlowScopeWalker walker = new FlowScopeWalker(flowScope);
        walker.addPreCollector(stackCollector);
        ExecutionEntity scopeExecution = null;
        if (this.ancestorActivityInstanceId == null) {
            walker.walkWhile(new TreeWalker.WalkCondition<ScopeImpl>(){

                @Override
                public boolean isFulfilled(ScopeImpl element) {
                    return !mapping.getExecutions(element).isEmpty() || element == processDefinition;
                }
            });
            Set<ExecutionEntity> flowScopeExecutions = mapping.getExecutions((ScopeImpl)walker.getCurrentElement());
            if (flowScopeExecutions.size() > 1) {
                throw new ProcessEngineException("Ancestor activity execution is ambiguous for activity " + flowScope);
            }
            scopeExecution = flowScopeExecutions.iterator().next();
        } else {
            ActivityInstance tree = commandContext.runWithoutAuthentication(new Callable<ActivityInstance>(){

                @Override
                public ActivityInstance call() throws Exception {
                    return new GetActivityInstanceCmd(AbstractInstantiationCmd.this.processInstanceId).execute(commandContext);
                }
            });
            ActivityInstance ancestorInstance = this.findActivityInstance(tree, this.ancestorActivityInstanceId);
            final ExecutionEntity ancestorScopeExecution = this.getScopeExecutionForActivityInstance(processInstance, mapping, ancestorInstance);
            final ScopeImpl ancestorScope = this.getScopeForActivityInstance(processDefinition, ancestorInstance);
            walker.walkWhile(new TreeWalker.WalkCondition<ScopeImpl>(){

                @Override
                public boolean isFulfilled(ScopeImpl element) {
                    return mapping.getExecutions(element).contains(ancestorScopeExecution) && element == ancestorScope || element == processDefinition;
                }
            });
            Set<ExecutionEntity> flowScopeExecutions = mapping.getExecutions((ScopeImpl)walker.getCurrentElement());
            if (!flowScopeExecutions.contains(ancestorScopeExecution)) {
                throw new ProcessEngineException("Could not find scope execution for " + this.ancestorActivityInstanceId + " in parent hierarchy of flow element " + elementToInstantiate);
            }
            scopeExecution = ancestorScopeExecution;
        }
        List<PvmActivity> activitiesToInstantiate = stackCollector.getActivityStack();
        Collections.reverse(activitiesToInstantiate);
        ActivityImpl topMostActivity = null;
        if (!activitiesToInstantiate.isEmpty()) {
            topMostActivity = (ActivityImpl)activitiesToInstantiate.get(0);
        } else if (ActivityImpl.class.isAssignableFrom(elementToInstantiate.getClass())) {
            topMostActivity = (ActivityImpl)elementToInstantiate;
        }
        ActivityStartBehavior startBehavior = ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE;
        if (topMostActivity != null) {
            startBehavior = topMostActivity.getActivityStartBehavior();
            if (!activitiesToInstantiate.isEmpty()) {
                PvmActivity initialActivity = (PvmActivity)topMostActivity.getProperty("initial");
                PvmActivity secondTopMostActivity = null;
                if (activitiesToInstantiate.size() > 1) {
                    secondTopMostActivity = activitiesToInstantiate.get(1);
                } else if (ActivityImpl.class.isAssignableFrom(elementToInstantiate.getClass())) {
                    secondTopMostActivity = (PvmActivity)((Object)elementToInstantiate);
                }
                if (initialActivity != secondTopMostActivity) {
                    startBehavior = ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE;
                }
            }
        }
        switch (startBehavior) {
            case CANCEL_EVENT_SCOPE: {
                ScopeImpl scopeToCancel = topMostActivity.getEventScope();
                ExecutionEntity executionToCancel = this.getSingleExecutionForScope(mapping, scopeToCancel);
                if (executionToCancel != null) {
                    executionToCancel.deleteCascade("Cancelling activity " + topMostActivity + " executed.", this.skipCustomListeners, this.skipIoMappings);
                    this.instantiate(executionToCancel.getParent(), activitiesToInstantiate, elementToInstantiate);
                    break;
                }
                ExecutionEntity flowScopeExecution = this.getSingleExecutionForScope(mapping, topMostActivity.getFlowScope());
                this.instantiateConcurrent(flowScopeExecution, activitiesToInstantiate, elementToInstantiate);
                break;
            }
            case INTERRUPT_EVENT_SCOPE: {
                ScopeImpl scopeToCancel = topMostActivity.getEventScope();
                ExecutionEntity executionToCancel = this.getSingleExecutionForScope(mapping, scopeToCancel);
                executionToCancel.interrupt("Interrupting activity " + topMostActivity + " executed.", this.skipCustomListeners, this.skipIoMappings);
                executionToCancel.setActivity(null);
                executionToCancel.leaveActivityInstance();
                this.instantiate(executionToCancel, activitiesToInstantiate, elementToInstantiate);
                break;
            }
            case INTERRUPT_FLOW_SCOPE: {
                ScopeImpl scopeToCancel = topMostActivity.getFlowScope();
                ExecutionEntity executionToCancel = this.getSingleExecutionForScope(mapping, scopeToCancel);
                executionToCancel.interrupt("Interrupting activity " + topMostActivity + " executed.", this.skipCustomListeners, this.skipIoMappings);
                executionToCancel.setActivity(null);
                executionToCancel.leaveActivityInstance();
                this.instantiate(executionToCancel, activitiesToInstantiate, elementToInstantiate);
                break;
            }
            default: {
                if (scopeExecution.getExecutions().isEmpty() && scopeExecution.getActivity() == null) {
                    this.instantiate(scopeExecution, activitiesToInstantiate, elementToInstantiate);
                    break;
                }
                this.instantiateConcurrent(scopeExecution, activitiesToInstantiate, elementToInstantiate);
            }
        }
        return null;
    }

    protected ExecutionEntity getSingleExecutionForScope(ActivityExecutionMapping mapping, ScopeImpl scope) {
        Set<ExecutionEntity> executions = mapping.getExecutions(scope);
        if (!executions.isEmpty()) {
            if (executions.size() > 1) {
                throw new ProcessEngineException("Executions for activity " + scope + " ambiguous");
            }
            return executions.iterator().next();
        }
        return null;
    }

    protected boolean isConcurrentStart(ActivityStartBehavior startBehavior) {
        return startBehavior == ActivityStartBehavior.DEFAULT || startBehavior == ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE;
    }

    protected void instantiate(ExecutionEntity ancestorScopeExecution, List<PvmActivity> parentFlowScopes, CoreModelElement targetElement) {
        if (PvmTransition.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivities(parentFlowScopes, null, (PvmTransition)((Object)targetElement), this.variables, this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else if (PvmActivity.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivities(parentFlowScopes, (PvmActivity)((Object)targetElement), null, this.variables, this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else {
            throw new ProcessEngineException("Cannot instantiate element " + targetElement);
        }
    }

    protected void instantiateConcurrent(ExecutionEntity ancestorScopeExecution, List<PvmActivity> parentFlowScopes, CoreModelElement targetElement) {
        if (PvmTransition.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivitiesConcurrent(parentFlowScopes, null, (PvmTransition)((Object)targetElement), this.variables, this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else if (PvmActivity.class.isAssignableFrom(targetElement.getClass())) {
            ancestorScopeExecution.executeActivitiesConcurrent(parentFlowScopes, (PvmActivity)((Object)targetElement), null, this.variables, this.variablesLocal, this.skipCustomListeners, this.skipIoMappings);
        } else {
            throw new ProcessEngineException("Cannot instantiate element " + targetElement);
        }
    }

    protected abstract ScopeImpl getTargetFlowScope(ProcessDefinitionImpl var1);

    protected abstract CoreModelElement getTargetElement(ProcessDefinitionImpl var1);
}

