/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.calendar;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.CronExpression;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class CycleBusinessCalendar
implements BusinessCalendar {
    public static String NAME = "cycle";

    @Override
    public Date resolveDuedate(String duedateDescription) {
        try {
            if (duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription).getDateAfter();
            }
            CronExpression ce = new CronExpression(duedateDescription);
            return ce.getTimeAfter(ClockUtil.getCurrentTime());
        }
        catch (Exception e) {
            throw new ProcessEngineException("Failed to parse cron expression: " + duedateDescription, e);
        }
    }
}

