/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class ParallelMultiInstanceActivityBehavior
extends MultiInstanceActivityBehavior {
    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        int i;
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        PvmActivity nestedActivity = execution.getActivity().getActivities().get(0);
        execution.setActivity(null);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (i = 0; i < nrOfInstances; ++i) {
            ActivityExecution concurrentChild = execution.createExecution();
            concurrentChild.setConcurrent(true);
            concurrentChild.setScope(false);
            concurrentExecutions.add(concurrentChild);
        }
        for (i = 0; i < nrOfInstances; ++i) {
            ActivityExecution activityExecution = (ActivityExecution)concurrentExecutions.get(i);
            if (!activityExecution.isActive()) continue;
            this.performInstance(activityExecution, nestedActivity, i);
        }
        if (!execution.getExecutions().isEmpty()) {
            execution.inactivate();
        }
    }

    @Override
    public void concurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        int nrOfCompletedInstances = this.getLoopVariable(scopeExecution, "nrOfCompletedInstances") + 1;
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances") - 1;
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances);
        endedExecution.inactivate();
        endedExecution.setActivityInstanceId(null);
        scopeExecution.forceUpdate();
        if (this.completionConditionSatisfied(endedExecution) || this.allExecutionsEnded(scopeExecution, endedExecution)) {
            ArrayList<? extends ActivityExecution> childExecutions = new ArrayList<ActivityExecution>(scopeExecution.getExecutions());
            for (ActivityExecution activityExecution : childExecutions) {
                if (activityExecution.isActive() || activityExecution.getActivity() == null) {
                    ((PvmExecutionImpl)activityExecution).deleteCascade("Multi instance completion condition satisfied.");
                    continue;
                }
                activityExecution.remove();
            }
            scopeExecution.setActivity((PvmActivity)((Object)endedExecution.getActivity().getFlowScope()));
            scopeExecution.setActive(true);
            this.leave(scopeExecution);
        }
    }

    protected boolean allExecutionsEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        return endedExecution.findInactiveConcurrentExecutions(endedExecution.getActivity()).size() == scopeExecution.getExecutions().size();
    }

    @Override
    public void complete(ActivityExecution scopeExecution) {
    }
}

