/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.variable.value.IntegerValue;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements CompositeActivityBehavior {
    protected static final Logger LOGGER = Logger.getLogger(MultiInstanceActivityBehavior.class.getName());
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected final String LOOP_COUNTER = "loopCounter";
    protected Expression loopCardinalityExpression;
    protected Expression completionConditionExpression;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances == 0) {
            this.leave(execution);
        } else {
            if (nrOfInstances < 0) {
                throw new ProcessEngineException("Invalid number of instances: must be positive integer value or zero, but was " + nrOfInstances);
            }
            this.createInstances(execution, nrOfInstances);
        }
    }

    protected void performInstance(ActivityExecution execution, PvmActivity activity, int loopCounter) {
        this.setLoopVariable(execution, "loopCounter", loopCounter);
        this.evaluateCollectionVariable(execution, loopCounter);
        execution.executeActivity(activity);
    }

    protected void evaluateCollectionVariable(ActivityExecution execution, int loopCounter) {
        if (this.usesCollection() && this.collectionElementVariable != null) {
            Collection collection = null;
            if (this.collectionExpression != null) {
                collection = (Collection)this.collectionExpression.getValue(execution);
            } else if (this.collectionVariable != null) {
                collection = (Collection)execution.getVariable(this.collectionVariable);
            }
            Object value = this.getElementAtIndex(loopCounter, collection);
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
    }

    protected abstract void createInstances(ActivityExecution var1, int var2) throws Exception;

    protected int resolveNrOfInstances(ActivityExecution execution) {
        int nrOfInstances = -1;
        if (this.loopCardinalityExpression != null) {
            nrOfInstances = this.resolveLoopCardinality(execution);
        } else if (this.collectionExpression != null) {
            Object obj = this.collectionExpression.getValue(execution);
            if (!(obj instanceof Collection)) {
                throw new ProcessEngineException(this.collectionExpression.getExpressionText() + "' didn't resolve to a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else if (this.collectionVariable != null) {
            Object obj = execution.getVariable(this.collectionVariable);
            if (!(obj instanceof Collection)) {
                throw new ProcessEngineException("Variable " + this.collectionVariable + "' is not a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else {
            throw new ProcessEngineException("Couldn't resolve collection expression nor variable reference");
        }
        return nrOfInstances;
    }

    protected Object getElementAtIndex(int i, Collection<?> collection) {
        Object value = null;
        Iterator<?> it = collection.iterator();
        for (int index = 0; index <= i; ++index) {
            value = it.next();
        }
        return value;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null;
    }

    protected int resolveLoopCardinality(ActivityExecution execution) {
        Object value = this.loopCardinalityExpression.getValue(execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new ProcessEngineException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue(execution);
            if (!(value instanceof Boolean)) {
                throw new ProcessEngineException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Completion condition of multi-instance satisfied: " + booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    protected void setLoopVariable(ActivityExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(ActivityExecution execution, String variableName) {
        IntegerValue value = (IntegerValue)execution.getVariableLocalTyped(variableName);
        EnsureUtil.ensureNotNull("The variable \"" + variableName + "\" could not be found in execution with id " + execution.getId(), "value", (Object)value);
        return (Integer)value.getValue();
    }

    protected Integer getLocalLoopVariable(ActivityExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public Expression getCompletionConditionExpression() {
        return this.completionConditionExpression;
    }

    public void setCompletionConditionExpression(Expression completionConditionExpression) {
        this.completionConditionExpression = completionConditionExpression;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }
}

