/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.CompensationUtil;
import org.camunda.bpm.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.Collector;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.TreeWalker;

public class IntermediateThrowCompensationEventActivityBehavior
extends FlowNodeActivityBehavior {
    protected final CompensateEventDefinition compensateEventDefinition;

    public IntermediateThrowCompensationEventActivityBehavior(CompensateEventDefinition compensateEventDefinition) {
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        String activityRef = this.compensateEventDefinition.getActivityRef();
        ExecutionEntity scopeExecution = (ExecutionEntity)(execution.isScope() ? execution : execution.getParent());
        List<CompensateEventSubscriptionEntity> eventSubscriptions = this.collectCompensateEventSubScriptions(execution);
        if (activityRef != null) {
            ActivityImpl activityToCompensate = scopeExecution.getProcessDefinition().findActivity(activityRef);
            String compensationHandlerId = (String)activityToCompensate.getProperty("compensationHandler");
            String subscriptionActivityId = null;
            subscriptionActivityId = compensationHandlerId != null ? compensationHandlerId : activityRef;
            ArrayList<CompensateEventSubscriptionEntity> eventSubscriptionsForActivity = new ArrayList<CompensateEventSubscriptionEntity>();
            for (CompensateEventSubscriptionEntity subscription : eventSubscriptions) {
                if (!subscriptionActivityId.equals(subscription.getActivityId())) continue;
                eventSubscriptionsForActivity.add(subscription);
            }
            eventSubscriptions = eventSubscriptionsForActivity;
        }
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            CompensationUtil.throwCompensationEvent(eventSubscriptions, execution, false);
        }
    }

    protected List<CompensateEventSubscriptionEntity> collectCompensateEventSubScriptions(ActivityExecution execution) {
        final Map<ScopeImpl, PvmExecutionImpl> scopeExecutionMapping = execution.createActivityExecutionMapping();
        ScopeImpl activity = (ScopeImpl)((Object)execution.getActivity());
        final HashSet subscriptions = new HashSet();
        Collector<ScopeImpl> eventSubscriptionCollector = new Collector<ScopeImpl>(){

            @Override
            public void collect(ScopeImpl obj) {
                PvmExecutionImpl execution = (PvmExecutionImpl)scopeExecutionMapping.get(obj);
                subscriptions.addAll(((ExecutionEntity)execution).getCompensateEventSubscriptions());
            }
        };
        new FlowScopeWalker(activity).addPostCollector(eventSubscriptionCollector).walkUntil(new TreeWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                Boolean consumesCompensationProperty = (Boolean)element.getProperty("consumesCompensation");
                return consumesCompensationProperty == null || consumesCompensationProperty == Boolean.TRUE;
            }
        });
        return new ArrayList<CompensateEventSubscriptionEntity>(subscriptions);
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (execution.getExecutions().isEmpty()) {
            this.leave(execution);
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }
}

