/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class BpmnActivityBehavior {
    private static Logger log = Logger.getLogger(BpmnActivityBehavior.class.getName());

    public void performDefaultOutgoingBehavior(ActivityExecution activityExceution) {
        this.performOutgoingBehavior(activityExceution, true, false, null);
    }

    public void performIgnoreConditionsOutgoingBehavior(ActivityExecution activityExecution) {
        this.performOutgoingBehavior(activityExecution, false, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performOutgoingBehavior(ActivityExecution execution, boolean checkConditions, boolean throwExceptionIfExecutionStuck, List<ActivityExecution> reusableExecutions) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Leaving activity '" + execution.getActivity().getId() + "'");
        }
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        for (PvmTransition outgoingTransition : outgoingTransitions) {
            Condition condition;
            if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && checkConditions && !condition.evaluate(execution)) continue;
            transitionsToTake.add(outgoingTransition);
        }
        if (transitionsToTake.size() == 1) {
            execution.leaveActivityViaTransition((PvmTransition)transitionsToTake.get(0));
            return;
        } else if (transitionsToTake.size() >= 1) {
            if (reusableExecutions == null || reusableExecutions.isEmpty()) {
                execution.leaveActivityViaTransitions(transitionsToTake, Arrays.asList(execution));
                return;
            } else {
                execution.leaveActivityViaTransitions(transitionsToTake, reusableExecutions);
            }
            return;
        } else if (defaultSequenceFlow != null) {
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ProcessEngineException("Default sequence flow '" + defaultSequenceFlow + "' could not be not found");
            execution.leaveActivityViaTransition(defaultTransition);
            return;
        } else {
            if (!outgoingTransitions.isEmpty()) {
                throw new ProcessEngineException("No conditional sequence flow leaving the Flow Node '" + execution.getActivity().getId() + "' could be selected for continuing the process");
            }
            Object isForCompensation = execution.getActivity().getProperty("isForCompensation");
            if (isForCompensation != null && ((Boolean)isForCompensation).booleanValue()) {
                execution.endCompensation();
                return;
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No outgoing sequence flow found for " + execution.getActivity().getId() + ". Ending execution.");
                }
                execution.end(true);
                if (!throwExceptionIfExecutionStuck) return;
                throw new ProcessEngineException("No outgoing sequence flow of the inclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
            }
        }
    }
}

