/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.Collector;
import org.camunda.bpm.engine.impl.tree.TreeWalker;

public class AbstractBpmnActivityBehavior
extends FlowNodeActivityBehavior {
    private static final Logger LOG = Logger.getLogger(AbstractBpmnActivityBehavior.class.getName());

    @Override
    protected void leave(ActivityExecution execution) {
        PvmActivity currentActivity = execution.getActivity();
        ActivityImpl compensationHandler = this.getCompensationHandler(currentActivity);
        if (compensationHandler != null) {
            this.createCompensateEventSubscription(execution, compensationHandler);
        }
        super.leave(execution);
    }

    protected ActivityImpl getCompensationHandler(PvmActivity activity) {
        String compensationHandlerId = (String)activity.getProperty("compensationHandler");
        if (compensationHandlerId != null) {
            return (ActivityImpl)activity.getProcessDefinition().findActivity(compensationHandlerId);
        }
        return null;
    }

    protected void createCompensateEventSubscription(ActivityExecution execution, ActivityImpl compensationHandler) {
        PvmActivity currentActivity = execution.getActivity();
        PvmScope levelOfSubprocessScope = currentActivity.getLevelOfSubprocessScope();
        ActivityExecution levelOfSubprocessScopeExecution = execution.findExecutionForFlowScope(levelOfSubprocessScope);
        CompensateEventSubscriptionEntity.createAndInsert((ExecutionEntity)levelOfSubprocessScopeExecution, compensationHandler);
    }

    protected void propagateExceptionAsError(Exception exception, ActivityExecution execution) throws Exception {
        if (exception instanceof ProcessEngineException && exception.getCause() == null) {
            throw exception;
        }
        this.propagateError(null, exception, execution);
    }

    protected void propagateBpmnError(BpmnError error, ActivityExecution execution) throws Exception {
        this.propagateError(error.getErrorCode(), null, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void propagateError(String errorCode, Exception origException, ActivityExecution execution) throws Exception {
        ScopeImpl scope = this.getCurrentFlowScope(execution);
        PvmExecutionImpl scopeExecution = (PvmExecutionImpl)(execution.isScope() ? execution : execution.getParent());
        ExecutionScopeHierarchyWalker scopeHierarchyWalker = new ExecutionScopeHierarchyWalker(scopeExecution, true);
        ErrorDeclarationFinder errorDeclarationFinder = new ErrorDeclarationFinder(scope, errorCode, origException, (PvmExecutionImpl)execution);
        ProcessInstanceCollector processInstanceCollector = new ProcessInstanceCollector();
        scopeHierarchyWalker.addPreCollector(errorDeclarationFinder);
        scopeHierarchyWalker.addPreCollector(processInstanceCollector);
        scopeHierarchyWalker.walkWhile(errorDeclarationFinder);
        PvmActivity errorHandlingActivity = errorDeclarationFinder.getErrorHandlerActivity();
        ErrorEventDefinition errorDefinition = errorDeclarationFinder.getErrorEventDefinition();
        PvmExecutionImpl errorHandlingExecution = null;
        if (errorHandlingActivity != null) {
            errorHandlingExecution = errorDeclarationFinder.getLastLeafExecution().findExecutionForFlowScope(errorHandlingActivity.getEventScope());
        }
        for (PvmExecutionImpl processInstance : processInstanceCollector.getProcessInstanceHierarchy()) {
            PvmExecutionImpl superExecution = processInstance.getSuperExecution();
            ActivityImpl activity = superExecution.getActivity();
            SubProcessActivityBehavior subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            subProcessActivityBehavior.completing(superExecution, processInstance);
        }
        if (errorHandlingExecution == null) {
            if (origException != null) throw origException;
            LOG.info(execution.getActivity().getId() + " throws error event with errorCode '" + errorCode + "', but no catching boundary event was defined. " + "Execution is ended (none end event semantics).");
            execution.end(true);
            return;
        } else {
            if (errorDefinition.getErrorCodeVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorCodeVariable(), errorCode);
            }
            errorHandlingExecution.executeActivity(errorHandlingActivity);
        }
    }

    protected ScopeImpl getCurrentFlowScope(ActivityExecution execution) {
        ScopeImpl scope = null;
        scope = execution.getTransition() != null ? execution.getTransition().getDestination().getFlowScope() : (ScopeImpl)((Object)execution.getActivity());
        scope = scope.isScope() ? scope : scope.getFlowScope();
        scope = LegacyBehavior.get().normalizeSecondNonScope(scope);
        return scope;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if ("compensationDone".equals(signalName)) {
            this.signalCompensationDone(execution, signalData);
        } else {
            super.signal(execution, signalName, signalData);
        }
    }

    protected void signalCompensationDone(ActivityExecution execution, Object signalData) {
        if (execution.getExecutions().isEmpty()) {
            if (execution.getParent() != null) {
                ActivityExecution parent = execution.getParent();
                execution.remove();
                parent.signal("compensationDone", signalData);
            }
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }

    public static class ProcessInstanceCollector
    implements Collector<PvmExecutionImpl> {
        protected List<PvmExecutionImpl> processInstanceHierarchy = new ArrayList<PvmExecutionImpl>();

        @Override
        public void collect(PvmExecutionImpl obj) {
            if (obj.getSuperExecution() != null) {
                this.processInstanceHierarchy.add(obj);
            }
        }

        public List<PvmExecutionImpl> getProcessInstanceHierarchy() {
            return this.processInstanceHierarchy;
        }
    }

    public static class ErrorDeclarationFinder
    implements Collector<PvmExecutionImpl>,
    TreeWalker.WalkCondition<PvmExecutionImpl> {
        protected ScopeImpl currentScope;
        protected String errorCode;
        protected Exception exception;
        protected ErrorEventDefinition errorEventDefinition;
        protected PvmActivity errorHandlerActivity;
        protected PvmExecutionImpl lastLeafExecution;

        public ErrorDeclarationFinder(ScopeImpl currentScope, String errorCode, Exception exception, PvmExecutionImpl lastLeafExecution) {
            this.currentScope = currentScope;
            this.errorCode = errorCode;
            this.exception = exception;
            this.lastLeafExecution = lastLeafExecution;
        }

        @Override
        public boolean isFulfilled(PvmExecutionImpl element) {
            if (this.currentScope == null) {
                return true;
            }
            List errorEventDefinitions = (List)this.currentScope.getProperty("errorEventDefinitions");
            if (errorEventDefinitions != null) {
                for (ErrorEventDefinition errorEventDefinition : errorEventDefinitions) {
                    if ((this.exception == null || !errorEventDefinition.catchesException(this.exception)) && (this.exception != null || !errorEventDefinition.catchesError(this.errorCode))) continue;
                    this.errorHandlerActivity = this.currentScope.getProcessDefinition().findActivity(errorEventDefinition.getHandlerActivityId());
                    this.errorEventDefinition = errorEventDefinition;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void collect(PvmExecutionImpl obj) {
            PvmExecutionImpl superExecution;
            this.currentScope = this.currentScope.getFlowScope();
            if (this.currentScope == null && (superExecution = obj.getSuperExecution()) != null) {
                this.currentScope = superExecution.getActivity();
                this.lastLeafExecution = superExecution;
            }
            if (this.currentScope != null) {
                this.currentScope = this.currentScope.isScope() ? this.currentScope : this.currentScope.getFlowScope();
                this.currentScope = LegacyBehavior.get().normalizeSecondNonScope(this.currentScope);
            }
        }

        public PvmActivity getErrorHandlerActivity() {
            return this.errorHandlerActivity;
        }

        public ErrorEventDefinition getErrorEventDefinition() {
            return this.errorEventDefinition;
        }

        public PvmExecutionImpl getLastLeafExecution() {
            return this.lastLeafExecution;
        }
    }

    public static class ExecutionScopeHierarchyWalker
    extends TreeWalker<PvmExecutionImpl> {
        protected boolean considerSuperProcessInstances;

        public ExecutionScopeHierarchyWalker(PvmExecutionImpl initialElement, boolean considerSuperProcessInstances) {
            super(initialElement);
            this.considerSuperProcessInstances = considerSuperProcessInstances;
        }

        @Override
        protected PvmExecutionImpl nextElement() {
            return ((PvmExecutionImpl)this.currentElement).getParentScopeExecution(this.considerSuperProcessInstances);
        }
    }
}

