/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util.xml;

import org.camunda.bpm.engine.BpmnParseException;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.xml.sax.SAXParseException;

public class Problem {
    protected String errorMessage;
    protected String resource;
    protected int line;
    protected int column;

    public Problem(SAXParseException e, String resource) {
        this.concatenateErrorMessages(e);
        this.resource = resource;
        this.line = e.getLineNumber();
        this.column = e.getColumnNumber();
    }

    public Problem(String errorMessage, String resourceName, Element element) {
        this.errorMessage = errorMessage;
        this.resource = resourceName;
        if (element != null) {
            this.line = element.getLine();
            this.column = element.getColumn();
        }
    }

    public Problem(BpmnParseException exception, String resourceName) {
        this.concatenateErrorMessages(exception);
        this.resource = resourceName;
        Element element = exception.getElement();
        if (element != null) {
            this.line = element.getLine();
            this.column = element.getColumn();
        }
    }

    protected void concatenateErrorMessages(Throwable throwable) {
        while (throwable != null) {
            this.errorMessage = this.errorMessage == null ? throwable.getMessage() : this.errorMessage + ": " + throwable.getMessage();
            throwable = throwable.getCause();
        }
    }

    public String toString() {
        return this.errorMessage + (this.resource != null ? " | " + this.resource : "") + " | line " + this.line + " | column " + this.column;
    }
}

