/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.AbstractPvmEventAtomicOperation;

public class PvmAtomicOperationProcessStart
extends AbstractPvmEventAtomicOperation {
    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        ProcessInstanceStartContext startContext = execution.getProcessInstanceStartContext();
        return startContext != null && startContext.isAsync();
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.getProcessInstanceStartContext();
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        ProcessInstanceStartContext processInstanceStartContext = execution.getProcessInstanceStartContext();
        List<ActivityImpl> initialActivityStack = processDefinition.getInitialActivityStack(processInstanceStartContext.getInitial());
        execution.setActivity(initialActivityStack.get(0));
        execution.performOperation(PROCESS_START_INITIAL);
    }

    @Override
    public String getCanonicalName() {
        return "process-start";
    }
}

