/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;

public class MessageJobDeclaration
extends JobDeclaration<MessageEntity> {
    public static final String ASYNC_BEFORE = "async-before";
    public static final String ASYNC_AFTER = "async-after";
    private static final long serialVersionUID = 1L;
    protected String[] operationIdentifier;

    public MessageJobDeclaration(String[] operationsIdentifier) {
        super("async-continuation");
        this.operationIdentifier = operationsIdentifier;
    }

    @Override
    protected MessageEntity newJobInstance(ExecutionEntity execution) {
        MessageEntity message = new MessageEntity();
        message.setExecution(execution);
        message.setJobHandlerType("async-continuation");
        return message;
    }

    public void setJobHandlerConfiguration(MessageEntity message, ExecutionEntity execution, AtomicOperation executionOperation) {
        String configuration = executionOperation.getCanonicalName();
        ActivityImpl activity = execution.getActivity();
        if (activity != null && activity.isAsyncAfter() && execution.getTransition() != null) {
            configuration = configuration + "$" + execution.getTransition().getId();
        }
        message.setJobHandlerConfiguration(configuration);
    }

    public boolean isApplicableForOperation(AtomicOperation operation) {
        for (String identifier : this.operationIdentifier) {
            if (!operation.getCanonicalName().equals(identifier)) continue;
            return true;
        }
        return false;
    }
}

