/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.execution;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.CaseVariableListener;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableListener;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnIfPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnOnPartDeclaration;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.listener.CaseVariableListenerInvocation;
import org.camunda.bpm.engine.impl.variable.listener.DelegateCaseVariableInstanceImpl;
import org.camunda.bpm.engine.task.Task;

public abstract class CmmnExecution
extends CoreExecution
implements CmmnCaseInstance {
    private static final long serialVersionUID = 1L;
    protected transient CmmnCaseDefinition caseDefinition;
    protected transient CmmnActivity activity;
    protected transient CmmnActivity nextActivity;
    protected boolean required = false;
    protected int previousState;
    protected int currentState = CaseExecutionState.NEW.getStateCode();
    protected List<String> satisfiedSentries;
    protected Queue<VariableEvent> variableEventsQueue;
    protected transient TaskEntity task;

    @Override
    public abstract List<? extends CmmnExecution> getCaseExecutions();

    protected abstract List<? extends CmmnExecution> getCaseExecutionsInternal();

    @Override
    public CmmnExecution findCaseExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (CmmnExecution cmmnExecution : this.getCaseExecutions()) {
            CmmnExecution result = cmmnExecution.findCaseExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TaskEntity getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public TaskEntity createTask(TaskDecorator taskDecorator) {
        TaskEntity task = TaskEntity.createAndInsert(this);
        task.setCaseExecution(this);
        this.setTask(task);
        taskDecorator.decorate(task, this);
        Context.getCommandContext().getHistoricTaskInstanceManager().createHistoricTask(task);
        task.fireEvent("create");
        return task;
    }

    public abstract PvmExecutionImpl getSuperExecution();

    public abstract void setSuperExecution(PvmExecutionImpl var1);

    public abstract PvmExecutionImpl getSubProcessInstance();

    public abstract void setSubProcessInstance(PvmExecutionImpl var1);

    @Override
    public abstract PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition var1);

    @Override
    public abstract PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition var1, String var2);

    @Override
    public abstract PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition var1, String var2, String var3);

    public abstract CmmnExecution getSubCaseInstance();

    public abstract void setSubCaseInstance(CmmnExecution var1);

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1);

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1, String var2);

    public abstract CmmnExecution getSuperCaseExecution();

    public abstract void setSuperCaseExecution(CmmnExecution var1);

    protected abstract CmmnSentryPart newSentryPart();

    protected abstract void addSentryPart(CmmnSentryPart var1);

    @Override
    public void createSentryParts() {
        CmmnActivity activity = this.getActivity();
        EnsureUtil.ensureNotNull("Case execution '" + this.id + "': has no current activity", "activity", (Object)activity);
        List<CmmnSentryDeclaration> sentries = activity.getSentries();
        if (sentries != null && !sentries.isEmpty()) {
            for (CmmnSentryDeclaration sentryDeclaration : sentries) {
                CmmnIfPartDeclaration ifPartDeclaration = sentryDeclaration.getIfPart();
                if (ifPartDeclaration != null) {
                    CmmnSentryPart ifPart = this.createIfPart(sentryDeclaration, ifPartDeclaration);
                    this.addSentryPart(ifPart);
                }
                List<CmmnOnPartDeclaration> onPartDeclarations = sentryDeclaration.getOnParts();
                for (CmmnOnPartDeclaration onPartDeclaration : onPartDeclarations) {
                    CmmnSentryPart onPart = this.createOnPart(sentryDeclaration, onPartDeclaration);
                    this.addSentryPart(onPart);
                }
            }
        }
    }

    protected CmmnSentryPart createOnPart(CmmnSentryDeclaration sentryDeclaration, CmmnOnPartDeclaration onPartDeclaration) {
        CmmnSentryPart sentryPart = this.createSentryPart(sentryDeclaration, "planItemOnPart");
        String standardEvent = onPartDeclaration.getStandardEvent();
        sentryPart.setStandardEvent(standardEvent);
        CmmnActivity source = onPartDeclaration.getSource();
        EnsureUtil.ensureNotNull("The source of sentry '" + sentryDeclaration.getId() + "' is null.", "source", (Object)source);
        String sourceActivityId = source.getId();
        CmmnExecution sourceCaseExecution = this.findCaseExecution(sourceActivityId);
        sentryPart.setSourceCaseExecution(sourceCaseExecution);
        return sentryPart;
    }

    protected CmmnSentryPart createIfPart(CmmnSentryDeclaration sentryDeclaration, CmmnIfPartDeclaration ifPartDeclaration) {
        return this.createSentryPart(sentryDeclaration, "ifPart");
    }

    protected CmmnSentryPart createSentryPart(CmmnSentryDeclaration sentryDeclaration, String type) {
        CmmnSentryPart newSentryPart = this.newSentryPart();
        newSentryPart.setType(type);
        newSentryPart.setCaseInstance(this.getCaseInstance());
        newSentryPart.setCaseExecution(this);
        String sentryId = sentryDeclaration.getId();
        newSentryPart.setSentryId(sentryId);
        return newSentryPart;
    }

    public void handleChildTransition(CmmnExecution child, String transition) {
        List<String> affectedSentries = this.collectAffectedSentries(child, transition);
        this.forceUpdateOnCaseSentryPart(affectedSentries);
        List<String> satisfiedSentries = this.getSatisfiedSentries(affectedSentries);
        this.fireSentries(satisfiedSentries);
        if (this.isActive()) {
            Map<String, List<CmmnSentryPart>> sentries = this.getSentries();
            ArrayList<String> notAffectedSentries = new ArrayList<String>();
            for (String sentryId : sentries.keySet()) {
                if (affectedSentries.contains(sentryId) || !this.containsIfPart(sentryId)) continue;
                notAffectedSentries.add(sentryId);
            }
            satisfiedSentries = this.getSatisfiedSentries(notAffectedSentries);
            this.fireSentries(satisfiedSentries);
        }
    }

    protected List<String> collectAffectedSentries(CmmnExecution child, String transition) {
        List<? extends CmmnSentryPart> sentryParts = this.getCaseSentryParts();
        ArrayList<String> affectedSentries = new ArrayList<String>();
        for (CmmnSentryPart cmmnSentryPart : sentryParts) {
            String standardEvent;
            String sourceCaseExecutionId = cmmnSentryPart.getSourceCaseExecutionId();
            if (!child.getId().equals(sourceCaseExecutionId) || !transition.equals(standardEvent = cmmnSentryPart.getStandardEvent()) || cmmnSentryPart.isSatisfied()) continue;
            String sentryId = cmmnSentryPart.getSentryId();
            cmmnSentryPart.setSatisfied(true);
            if (affectedSentries.contains(sentryId)) continue;
            affectedSentries.add(sentryId);
        }
        return affectedSentries;
    }

    protected void forceUpdateOnCaseSentryPart(List<String> sentryIds) {
        for (String sentryId : sentryIds) {
            List<? extends CmmnSentryPart> sentryParts = this.findSentry(sentryId);
            for (CmmnSentryPart cmmnSentryPart : sentryParts) {
                if (!(cmmnSentryPart instanceof CaseSentryPartEntity)) continue;
                CaseSentryPartEntity sentryPartEntity = (CaseSentryPartEntity)cmmnSentryPart;
                sentryPartEntity.forceUpdate();
            }
        }
    }

    protected List<String> getSatisfiedSentries(List<String> sentryIds) {
        ArrayList<String> result = new ArrayList<String>();
        if (sentryIds != null) {
            for (String sentryId : sentryIds) {
                if (!this.isSentrySatisfied(sentryId)) continue;
                result.add(sentryId);
            }
        }
        return result;
    }

    protected void fireSentries(List<String> satisfiedSentries) {
        if (satisfiedSentries != null && !satisfiedSentries.isEmpty()) {
            List<? extends CmmnExecution> children = this.getCaseExecutions();
            for (CmmnExecution cmmnExecution : children) {
                cmmnExecution.checkAndFireExitCriteria(satisfiedSentries);
                cmmnExecution.checkAndFireEntryCriteria(satisfiedSentries);
            }
            if (this.isCaseInstanceExecution() && this.isActive()) {
                this.checkAndFireExitCriteria(satisfiedSentries);
            }
        }
    }

    protected void checkAndFireExitCriteria(List<String> satisfiedSentries) {
        if (!(this.isNew() || this.isCompleted() || this.isTerminated())) {
            CmmnActivity activity = this.getActivity();
            EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + this.getId() + "': has no current activity.", "activity", (Object)activity);
            List<CmmnSentryDeclaration> exitCriteria = activity.getExitCriteria();
            for (CmmnSentryDeclaration sentryDeclaration : exitCriteria) {
                if (sentryDeclaration == null || !satisfiedSentries.contains(sentryDeclaration.getId())) continue;
                this.fireExitCriteria();
                break;
            }
        }
    }

    protected void checkAndFireEntryCriteria(List<String> satisfiedSentries) {
        if (this.isAvailable()) {
            CmmnActivity activity = this.getActivity();
            EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + this.getId() + "': has no current activity.", "activity", (Object)activity);
            List<CmmnSentryDeclaration> entryCriteria = activity.getEntryCriteria();
            for (CmmnSentryDeclaration sentryDeclaration : entryCriteria) {
                if (sentryDeclaration == null || !satisfiedSentries.contains(sentryDeclaration.getId())) continue;
                this.fireEntryCriteria();
                break;
            }
        }
    }

    public void fireExitCriteria() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_FIRE_EXIT_CRITERIA);
    }

    public void fireEntryCriteria() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_FIRE_ENTRY_CRITERIA);
    }

    public abstract List<? extends CmmnSentryPart> getCaseSentryParts();

    protected abstract List<? extends CmmnSentryPart> findSentry(String var1);

    protected abstract Map<String, List<CmmnSentryPart>> getSentries();

    @Override
    public boolean isSentrySatisfied(String sentryId) {
        List<? extends CmmnSentryPart> sentryParts = this.findSentry(sentryId);
        CmmnSentryPart ifPart = null;
        if (sentryParts != null && !sentryParts.isEmpty()) {
            for (CmmnSentryPart cmmnSentryPart : sentryParts) {
                if ("planItemOnPart".equals(cmmnSentryPart.getType())) {
                    if (cmmnSentryPart.isSatisfied()) continue;
                    return false;
                }
                ifPart = cmmnSentryPart;
                if (!ifPart.isSatisfied()) continue;
                return true;
            }
        }
        if (ifPart != null) {
            CmmnActivity activity = this.getActivity();
            EnsureUtil.ensureNotNull("Case execution '" + this.id + "': has no current activity", "activity", (Object)activity);
            CmmnSentryDeclaration cmmnSentryDeclaration = activity.getSentry(sentryId);
            EnsureUtil.ensureNotNull("Case execution '" + this.id + "': has no declaration for sentry '" + sentryId + "'", "sentryDeclaration", (Object)cmmnSentryDeclaration);
            CmmnIfPartDeclaration ifPartDeclaration = cmmnSentryDeclaration.getIfPart();
            EnsureUtil.ensureNotNull("Sentry declaration '" + sentryId + "' has no definied ifPart, but there should be one defined for case execution '" + this.id + "'.", "ifPartDeclaration", (Object)ifPartDeclaration);
            Expression condition = ifPartDeclaration.getCondition();
            EnsureUtil.ensureNotNull("A condition was expected for ifPart of Sentry declaration '" + sentryId + "' for case execution '" + this.id + "'.", "condition", (Object)condition);
            Object result = condition.getValue(this);
            EnsureUtil.ensureInstanceOf("condition expression returns non-Boolean", "result", result, Boolean.class);
            Boolean booleanResult = (Boolean)result;
            ifPart.setSatisfied(booleanResult);
            return booleanResult;
        }
        return true;
    }

    protected boolean containsIfPart(String sentryId) {
        List<? extends CmmnSentryPart> sentries = this.findSentry(sentryId);
        for (CmmnSentryPart cmmnSentryPart : sentries) {
            if (!"ifPart".equals(cmmnSentryPart.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCaseBusinessKey() {
        return this.getCaseInstance().getBusinessKey();
    }

    public CmmnCaseDefinition getCaseDefinition() {
        return this.caseDefinition;
    }

    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        this.caseDefinition = caseDefinition;
    }

    public abstract CmmnExecution getCaseInstance();

    public abstract void setCaseInstance(CmmnExecution var1);

    @Override
    public boolean isCaseInstanceExecution() {
        return this.getParent() == null;
    }

    @Override
    public String getCaseInstanceId() {
        return this.getCaseInstance().getId();
    }

    @Override
    public abstract CmmnExecution getParent();

    public abstract void setParent(CmmnExecution var1);

    @Override
    public CmmnActivity getActivity() {
        return this.activity;
    }

    public void setActivity(CmmnActivity activity) {
        this.activity = activity;
    }

    public CmmnActivity getNextActivity() {
        return this.nextActivity;
    }

    public void setNextActivity(CmmnActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    @Override
    public String getVariableScopeKey() {
        return "caseExecution";
    }

    @Override
    public AbstractVariableScope getParentVariableScope() {
        return this.getParent();
    }

    public void deleteCascade() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_DELETE_CASCADE);
    }

    @Override
    public void remove() {
        CmmnExecution parent = this.getParent();
        if (parent != null) {
            parent.getCaseExecutionsInternal().remove(this);
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public CaseExecutionState getCurrentState() {
        return CaseExecutionState.CASE_EXECUTION_STATES.get(this.getState());
    }

    @Override
    public void setCurrentState(CaseExecutionState currentState) {
        if (!this.isSuspending() && !this.isTerminating()) {
            this.previousState = this.currentState;
        }
        this.currentState = currentState.getStateCode();
    }

    public int getState() {
        return this.currentState;
    }

    public void setState(int state) {
        this.currentState = state;
    }

    @Override
    public boolean isNew() {
        return this.currentState == CaseExecutionState.NEW.getStateCode();
    }

    @Override
    public boolean isAvailable() {
        return this.currentState == CaseExecutionState.AVAILABLE.getStateCode();
    }

    @Override
    public boolean isEnabled() {
        return this.currentState == CaseExecutionState.ENABLED.getStateCode();
    }

    @Override
    public boolean isDisabled() {
        return this.currentState == CaseExecutionState.DISABLED.getStateCode();
    }

    @Override
    public boolean isActive() {
        return this.currentState == CaseExecutionState.ACTIVE.getStateCode();
    }

    @Override
    public boolean isCompleted() {
        return this.currentState == CaseExecutionState.COMPLETED.getStateCode();
    }

    @Override
    public boolean isSuspended() {
        return this.currentState == CaseExecutionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isSuspending() {
        return this.currentState == CaseExecutionState.SUSPENDING_ON_SUSPENSION.getStateCode() || this.currentState == CaseExecutionState.SUSPENDING_ON_PARENT_SUSPENSION.getStateCode();
    }

    @Override
    public boolean isTerminated() {
        return this.currentState == CaseExecutionState.TERMINATED.getStateCode();
    }

    @Override
    public boolean isTerminating() {
        return this.currentState == CaseExecutionState.TERMINATING_ON_TERMINATION.getStateCode() || this.currentState == CaseExecutionState.TERMINATING_ON_PARENT_TERMINATION.getStateCode() || this.currentState == CaseExecutionState.TERMINATING_ON_EXIT.getStateCode();
    }

    @Override
    public boolean isFailed() {
        return this.currentState == CaseExecutionState.FAILED.getStateCode();
    }

    @Override
    public boolean isClosed() {
        return this.currentState == CaseExecutionState.CLOSED.getStateCode();
    }

    @Override
    public CaseExecutionState getPreviousState() {
        return CaseExecutionState.CASE_EXECUTION_STATES.get(this.getPrevious());
    }

    public int getPrevious() {
        return this.previousState;
    }

    public void setPrevious(int previous) {
        this.previousState = previous;
    }

    @Override
    public void create() {
        this.create(null);
    }

    @Override
    public void create(Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(variables);
        }
        this.performOperation(CmmnAtomicOperation.CASE_INSTANCE_CREATE);
    }

    @Override
    public List<CmmnExecution> createChildExecutions(List<CmmnActivity> activities) {
        ArrayList<CmmnExecution> children = new ArrayList<CmmnExecution>();
        for (CmmnActivity currentActivity : activities) {
            CmmnExecution child = this.createCaseExecution(currentActivity);
            children.add(child);
        }
        return children;
    }

    @Override
    public void triggerChildExecutionsLifecycle(List<CmmnExecution> children) {
        for (CmmnExecution child : children) {
            if (!this.isActive()) break;
            if (!child.isNew()) continue;
            child.performOperation(CmmnAtomicOperation.CASE_EXECUTION_CREATE);
        }
    }

    protected abstract CmmnExecution createCaseExecution(CmmnActivity var1);

    protected abstract CmmnExecution newCaseExecution();

    @Override
    public void enable() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_ENABLE);
    }

    @Override
    public void disable() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_DISABLE);
    }

    @Override
    public void reenable() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_RE_ENABLE);
    }

    @Override
    public void manualStart() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_MANUAL_START);
    }

    @Override
    public void start() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_START);
    }

    @Override
    public void complete() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_COMPLETE);
    }

    @Override
    public void manualComplete() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_MANUAL_COMPLETE);
    }

    @Override
    public void occur() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_OCCUR);
    }

    @Override
    public void terminate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_TERMINATING_ON_TERMINATION);
    }

    @Override
    public void performTerminate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_TERMINATE);
    }

    @Override
    public void parentTerminate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_TERMINATING_ON_PARENT_TERMINATION);
    }

    @Override
    public void performParentTerminate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_PARENT_TERMINATE);
    }

    @Override
    public void exit() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_TERMINATING_ON_EXIT);
    }

    @Override
    public void performExit() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_EXIT);
    }

    @Override
    public void suspend() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_SUSPENDING_ON_SUSPENSION);
    }

    @Override
    public void performSuspension() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_SUSPEND);
    }

    @Override
    public void parentSuspend() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_SUSPENDING_ON_PARENT_SUSPENSION);
    }

    @Override
    public void performParentSuspension() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_PARENT_SUSPEND);
    }

    @Override
    public void resume() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_RESUME);
    }

    @Override
    public void parentResume() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_PARENT_RESUME);
    }

    @Override
    public void reactivate() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_RE_ACTIVATE);
    }

    @Override
    public void close() {
        this.performOperation(CmmnAtomicOperation.CASE_INSTANCE_CLOSE);
    }

    @Override
    public void dispatchEvent(VariableEvent variableEvent) {
        boolean invokeCustomListeners = Context.getProcessEngineConfiguration().isInvokeCustomVariableListeners();
        Map<String, List<VariableListener<?>>> listeners = this.getActivity().getVariableListeners(variableEvent.getEventName(), invokeCustomListeners);
        if (!listeners.isEmpty()) {
            this.getCaseInstance().queueVariableEvent(variableEvent, invokeCustomListeners);
        }
    }

    protected void queueVariableEvent(VariableEvent variableEvent, boolean includeCustomerListeners) {
        Queue<VariableEvent> variableEventsQueue = this.getVariableEventQueue();
        variableEventsQueue.add(variableEvent);
        if (variableEventsQueue.size() == 1) {
            this.invokeVariableListeners(includeCustomerListeners);
        }
    }

    protected void invokeVariableListeners(boolean includeCustomerListeners) {
        Queue<VariableEvent> variableEventsQueue = this.getVariableEventQueue();
        while (!variableEventsQueue.isEmpty()) {
            VariableEvent nextEvent = variableEventsQueue.peek();
            CmmnExecution sourceExecution = (CmmnExecution)nextEvent.getSourceScope();
            DelegateCaseVariableInstanceImpl delegateVariable = DelegateCaseVariableInstanceImpl.fromVariableInstance(nextEvent.getVariableInstance());
            delegateVariable.setEventName(nextEvent.getEventName());
            delegateVariable.setSourceExecution(sourceExecution);
            Map<String, List<VariableListener<?>>> listenersByActivity = sourceExecution.getActivity().getVariableListeners(delegateVariable.getEventName(), includeCustomerListeners);
            for (CmmnExecution currentExecution = sourceExecution; currentExecution != null; currentExecution = currentExecution.getParent()) {
                List<VariableListener<?>> listeners;
                if (currentExecution.getActivityId() == null || (listeners = listenersByActivity.get(currentExecution.getActivityId())) == null) continue;
                delegateVariable.setScopeExecution(currentExecution);
                for (VariableListener<?> listener : listeners) {
                    try {
                        CaseVariableListener caseVariableListener = (CaseVariableListener)listener;
                        CaseVariableListenerInvocation invocation = new CaseVariableListenerInvocation(caseVariableListener, delegateVariable, currentExecution);
                        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
                    }
                    catch (Exception e) {
                        throw new ProcessEngineException("Variable listener invocation failed: " + e.getMessage(), e);
                    }
                }
            }
            variableEventsQueue.remove();
        }
    }

    protected Queue<VariableEvent> getVariableEventQueue() {
        if (this.variableEventsQueue == null) {
            this.variableEventsQueue = new LinkedList<VariableEvent>();
        }
        return this.variableEventsQueue;
    }

    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }
}

