/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class SetJobRetriesCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String jobId;
    protected final String jobDefinitionId;
    protected final int retries;

    public SetJobRetriesCmd(String jobId, String jobDefinitionId, int retries) {
        if ((jobId == null || jobId.isEmpty()) && (jobDefinitionId == null || jobDefinitionId.isEmpty())) {
            throw new ProcessEngineException("Either job definition id or job id has to be provided as parameter.");
        }
        if (retries < 0) {
            throw new ProcessEngineException("The number of job retries must be a non-negative Integer, but '" + retries + "' has been provided.");
        }
        this.jobId = jobId;
        this.jobDefinitionId = jobDefinitionId;
        this.retries = retries;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.jobId != null) {
            this.setJobRetriesByJobId(commandContext);
        } else {
            this.setJobRetriesByJobDefinitionId(commandContext);
        }
        return null;
    }

    protected void setJobRetriesByJobId(CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        if (job != null) {
            if (job.isInInconsistentLockState()) {
                job.resetLock();
            }
        } else {
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'.");
        }
        job.setRetries(this.retries);
    }

    protected void setJobRetriesByJobDefinitionId(CommandContext commandContext) {
        commandContext.getJobManager().updateFailedJobRetriesByJobDefinitionId(this.jobDefinitionId, this.retries);
    }
}

