/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import org.camunda.bpm.engine.impl.core.variable.VariableMapImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.variable.VariableMap;

public class GetTaskFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    private static final long serialVersionUID = 1L;

    public GetTaskFormVariablesCmd(String taskId, Collection<String> variableNames, boolean deserializeObjectValues) {
        super(taskId, variableNames, deserializeObjectValues);
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.resourceId);
        if (task == null) {
            throw new BadUserRequestException("Cannot find task with id '" + this.resourceId + "'.");
        }
        VariableMapImpl result = new VariableMapImpl();
        TaskDefinition taskDefinition = task.getTaskDefinition();
        if (taskDefinition != null) {
            TaskFormData taskFormData = taskDefinition.getTaskFormHandler().createTaskForm(task);
            for (FormField formField : taskFormData.getFormFields()) {
                if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
                result.put(formField.getId(), (Object)this.createVariable(formField, task));
            }
        }
        task.collectVariables(result, this.formVariableNames, false, this.deserializeObjectValues);
        return result;
    }
}

