/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessApplicationDeploymentImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.instance.Case;

public class DeployCmd<T>
implements Command<Deployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DeployCmd.class.getName());
    protected DeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public Deployment execute(CommandContext commandContext) {
        this.acquireExclusiveLock(commandContext);
        DeploymentEntity deployment = this.initDeployment();
        Map<String, ResourceEntity> resourcesToDeploy = this.resolveResourcesToDeploy(commandContext, deployment);
        HashMap<String, ResourceEntity> resourcesToIgnore = new HashMap<String, ResourceEntity>(deployment.getResources());
        resourcesToIgnore.keySet().removeAll(resourcesToDeploy.keySet());
        if (!resourcesToDeploy.isEmpty()) {
            log.fine("Creating new deployment.");
            deployment.setResources(resourcesToDeploy);
            this.deploy(deployment);
        } else {
            log.fine("Using existing deployment.");
            deployment = this.getExistingDeployment(commandContext, deployment.getName());
        }
        this.scheduleProcessDefinitionActivation(commandContext, deployment);
        if (this.deploymentBuilder instanceof ProcessApplicationDeploymentBuilder) {
            Set<String> processesToRegisterFor = this.retrieveProcessKeysFromResources(resourcesToIgnore);
            ProcessApplicationRegistration registration = this.registerProcessApplication(commandContext, deployment, processesToRegisterFor);
            return new ProcessApplicationDeploymentImpl(deployment, registration);
        }
        this.registerWithJobExecutor(commandContext, deployment);
        return deployment;
    }

    protected void acquireExclusiveLock(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().isDeploymentLockUsed()) {
            commandContext.getPropertyManager().acquireExclusiveLock();
        }
    }

    protected DeploymentEntity initDeployment() {
        DeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        deployment.setDeploymentTime(ClockUtil.getCurrentTime());
        return deployment;
    }

    protected Map<String, ResourceEntity> resolveResourcesToDeploy(CommandContext commandContext, DeploymentEntity deployment) {
        Map<Object, Object> resourcesToDeploy = new HashMap();
        Map<String, ResourceEntity> containedResources = deployment.getResources();
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            Map<String, ResourceEntity> existingResources = commandContext.getResourceManager().findLatestResourcesByDeploymentName(deployment.getName(), containedResources.keySet());
            for (ResourceEntity deployedResource : containedResources.values()) {
                String resourceName = deployedResource.getName();
                ResourceEntity existingResource = existingResources.get(resourceName);
                if (existingResource != null && !existingResource.isGenerated() && !this.resourcesDiffer(deployedResource, existingResource)) continue;
                if (this.deploymentBuilder.isDeployChangedOnly()) {
                    resourcesToDeploy.put(resourceName, deployedResource);
                    continue;
                }
                resourcesToDeploy = containedResources;
                break;
            }
        } else {
            resourcesToDeploy = containedResources;
        }
        return resourcesToDeploy;
    }

    protected boolean resourcesDiffer(ResourceEntity resource, ResourceEntity existing) {
        byte[] savedBytes;
        byte[] bytes = resource.getBytes();
        return !Arrays.equals(bytes, savedBytes = existing.getBytes());
    }

    protected void deploy(DeploymentEntity deployment) {
        deployment.setNew(true);
        Context.getCommandContext().getDeploymentManager().insertDeployment(deployment);
    }

    protected DeploymentEntity getExistingDeployment(CommandContext commandContext, String deploymentName) {
        return commandContext.getDeploymentManager().findLatestDeploymentByName(deploymentName);
    }

    protected void scheduleProcessDefinitionActivation(CommandContext commandContext, DeploymentEntity deployment) {
        if (this.deploymentBuilder.getProcessDefinitionsActivationDate() != null) {
            for (ProcessDefinitionEntity processDefinitionEntity : deployment.getDeployedArtifacts(ProcessDefinitionEntity.class)) {
                SuspendProcessDefinitionCmd suspendProcessDefinitionCmd = new SuspendProcessDefinitionCmd(processDefinitionEntity, false, null);
                suspendProcessDefinitionCmd.execute(commandContext);
                ActivateProcessDefinitionCmd activateProcessDefinitionCmd = new ActivateProcessDefinitionCmd(processDefinitionEntity, false, this.deploymentBuilder.getProcessDefinitionsActivationDate());
                activateProcessDefinitionCmd.execute(commandContext);
            }
        }
    }

    protected ProcessApplicationRegistration registerProcessApplication(CommandContext commandContext, DeploymentEntity deployment, Set<String> additionalProcessKeysToRegisterFor) {
        ProcessApplicationDeploymentBuilderImpl appDeploymentBuilder = (ProcessApplicationDeploymentBuilderImpl)this.deploymentBuilder;
        ProcessApplicationReference appReference = appDeploymentBuilder.getProcessApplicationReference();
        HashSet<String> deploymentsToRegister = new HashSet<String>(Collections.singleton(deployment.getId()));
        if (appDeploymentBuilder.isResumePreviousVersions()) {
            HashSet<String> processDefinitionKeys = new HashSet<String>();
            List<ProcessDefinitionEntity> deployedProcesses = this.getDeployedProcesses(deployment);
            for (ProcessDefinitionEntity deployedProcess : deployedProcesses) {
                if (deployedProcess.getVersion() <= 1) continue;
                processDefinitionKeys.add(deployedProcess.getKey());
            }
            processDefinitionKeys.addAll(additionalProcessKeysToRegisterFor);
            this.resumePreviousVersions(commandContext, processDefinitionKeys, deploymentsToRegister);
        }
        return new RegisterProcessApplicationCmd(deploymentsToRegister, appReference).execute(commandContext);
    }

    protected List<ProcessDefinitionEntity> getDeployedProcesses(DeploymentEntity deployment) {
        List<ProcessDefinitionEntity> deployedProcessDefinitions = deployment.getDeployedArtifacts(ProcessDefinitionEntity.class);
        if (deployedProcessDefinitions == null) {
            deployedProcessDefinitions = new ProcessDefinitionQueryImpl(Context.getCommandContext()).deploymentId(deployment.getId()).list();
        }
        return deployedProcessDefinitions;
    }

    protected Set<String> retrieveProcessKeysFromResources(Map<String, ResourceEntity> resources) {
        HashSet<String> keys = new HashSet<String>();
        for (ResourceEntity resource : resources.values()) {
            BpmnModelInstance model;
            ByteArrayInputStream byteStream;
            if (this.isBpmnResource(resource)) {
                byteStream = new ByteArrayInputStream(resource.getBytes());
                model = Bpmn.readModelFromStream((InputStream)byteStream);
                for (Process process : model.getDefinitions().getChildElementsByType(Process.class)) {
                    keys.add(process.getId());
                }
                continue;
            }
            if (!this.isCmmnResource(resource)) continue;
            byteStream = new ByteArrayInputStream(resource.getBytes());
            model = Cmmn.readModelFromStream((InputStream)byteStream);
            for (Case cmmnCase : model.getDefinitions().getCases()) {
                keys.add(cmmnCase.getId());
            }
        }
        return keys;
    }

    protected boolean isBpmnResource(ResourceEntity resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
    }

    protected boolean isCmmnResource(ResourceEntity resourceEntity) {
        return StringUtil.hasAnySuffix(resourceEntity.getName(), CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
    }

    protected void resumePreviousVersions(CommandContext commandContext, Set<String> processDefinitionKeys, Set<String> deploymentsToRegister) {
        for (String processDefinitionKey : processDefinitionKeys) {
            List previousVersionDefinition = new ProcessDefinitionQueryImpl(commandContext).processDefinitionKey(processDefinitionKey).list();
            for (ProcessDefinition processDefinition : previousVersionDefinition) {
                deploymentsToRegister.add(processDefinition.getDeploymentId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWithJobExecutor(CommandContext commandContext, DeploymentEntity deployment) {
        try {
            new RegisterDeploymentCmd(deployment.getId()).execute(commandContext);
        }
        finally {
            DeploymentFailListener listener = new DeploymentFailListener(deployment.getId());
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not register transaction synchronization. Probably the TX has already been rolled back by application code.", e);
                listener.execute(commandContext);
            }
        }
    }
}

