/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.ScopeUtil;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class AbstractBpmnActivityBehavior
extends FlowNodeActivityBehavior {
    protected MultiInstanceActivityBehavior multiInstanceActivityBehavior;

    @Override
    protected void leave(ActivityExecution execution) {
        if (this.hasCompensationHandler(execution)) {
            this.createCompensateEventSubscription(execution);
        }
        if (!this.hasLoopCharacteristics()) {
            super.leave(execution);
        } else if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.leave(execution);
        }
    }

    protected boolean hasCompensationHandler(ActivityExecution execution) {
        return execution.getActivity().getProperty("compensationHandler") != null;
    }

    protected void createCompensateEventSubscription(ActivityExecution execution) {
        String compensationHandlerId = (String)execution.getActivity().getProperty("compensationHandler");
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ActivityImpl compensationHandlder = executionEntity.getProcessDefinition().findActivity(compensationHandlerId);
        ScopeImpl scopeActivitiy = compensationHandlder.getParent();
        ExecutionEntity scopeExecution = ScopeUtil.findScopeExecutionForScope(executionEntity, scopeActivitiy);
        CompensateEventSubscriptionEntity compensateEventSubscriptionEntity = CompensateEventSubscriptionEntity.createAndInsert(scopeExecution);
        compensateEventSubscriptionEntity.setActivity(compensationHandlder);
    }

    protected boolean hasLoopCharacteristics() {
        return this.hasMultiInstanceCharacteristics();
    }

    protected boolean hasMultiInstanceCharacteristics() {
        return this.multiInstanceActivityBehavior != null;
    }

    public MultiInstanceActivityBehavior getMultiInstanceActivityBehavior() {
        return this.multiInstanceActivityBehavior;
    }

    public void setMultiInstanceActivityBehavior(MultiInstanceActivityBehavior multiInstanceActivityBehavior) {
        this.multiInstanceActivityBehavior = multiInstanceActivityBehavior;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if ("compensationDone".equals(signalName)) {
            this.signalCompensationDone(execution, signalData);
        } else {
            super.signal(execution, signalName, signalData);
        }
    }

    protected void signalCompensationDone(ActivityExecution execution, Object signalData) {
        if (execution.getExecutions().isEmpty()) {
            if (execution.getParent() != null) {
                ActivityExecution parent = execution.getParent();
                execution.remove();
                parent.signal("compensationDone", signalData);
            }
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }
}

