/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ActivityInstantiationInstruction;
import org.camunda.bpm.engine.impl.cmd.ModifyProcessInstanceCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;

public class ProcessInstanceModificationBuilderImpl
implements ProcessInstanceModificationBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String processInstanceId;
    protected Set<String> activityInstancesToCancel = new HashSet<String>();
    protected List<ActivityInstantiationInstruction> activitiesToStartBefore = new ArrayList<ActivityInstantiationInstruction>();
    protected ActivityInstantiationInstruction currentActivity;

    public ProcessInstanceModificationBuilderImpl(CommandExecutor commandExecutor, String processInstanceId) {
        this(processInstanceId);
        this.commandExecutor = commandExecutor;
    }

    public ProcessInstanceModificationBuilderImpl(CommandContext commandContext, String processInstanceId) {
        this(processInstanceId);
        this.commandContext = commandContext;
    }

    public ProcessInstanceModificationBuilderImpl(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ProcessInstanceModificationBuilder cancelActivityInstance(String activityInstanceId) {
        this.activityInstancesToCancel.add(activityInstanceId);
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder startBeforeActivity(String activityId) {
        this.currentActivity = new ActivityInstantiationInstruction(activityId);
        this.activitiesToStartBefore.add(this.currentActivity);
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder setVariable(String name, Object value) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Variable name must not be null", "name", (Object)name);
        EnsureUtil.ensureNotNull(NotValidException.class, "No activity to start specified", "variable", (Object)this.currentActivity);
        this.currentActivity.addVariable(name, value);
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder setVariableLocal(String name, Object value) {
        EnsureUtil.ensureNotNull(NotValidException.class, "Variable name must not be null", "name", (Object)name);
        EnsureUtil.ensureNotNull(NotValidException.class, "No activity to start specified", "variableLocal", (Object)this.currentActivity);
        this.currentActivity.addVariableLocal(name, value);
        return this;
    }

    @Override
    public void execute() {
        ModifyProcessInstanceCmd cmd = new ModifyProcessInstanceCmd(this);
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(cmd);
        } else {
            cmd.execute(this.commandContext);
        }
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Set<String> getActivityInstancesToCancel() {
        return this.activityInstancesToCancel;
    }

    public List<ActivityInstantiationInstruction> getActivitiesToStartBefore() {
        return this.activitiesToStartBefore;
    }
}

