/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryValue;
import org.camunda.bpm.engine.impl.ExecutionQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;

public class ExecutionQueryImpl
extends AbstractVariableQueryImpl<ExecutionQuery, Execution>
implements ExecutionQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String activityId;
    protected String executionId;
    protected String processInstanceId;
    protected List<EventSubscriptionQueryValue> eventSubscriptions;
    protected boolean hasMessageEventSubscriptions;
    protected SuspensionState suspensionState;
    protected String incidentType;
    protected String incidentId;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    protected String superCaseInstanceId;
    protected String subCaseInstanceId;
    protected String caseInstanceId;
    private String businessKey;

    public ExecutionQueryImpl() {
    }

    public ExecutionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ExecutionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public boolean isProcessInstancesOnly() {
        return false;
    }

    @Override
    public ExecutionQueryImpl processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("Process definition id", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ExecutionQueryImpl processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("Process definition key", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ExecutionQueryImpl processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("Process instance id", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ExecutionQuery processInstanceBusinessKey(String businessKey) {
        EnsureUtil.ensureNotNull("Business key", (Object)businessKey);
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ExecutionQueryImpl executionId(String executionId) {
        EnsureUtil.ensureNotNull("Execution id", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public ExecutionQueryImpl activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public ExecutionQuery signalEventSubscription(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery signalEventSubscriptionName(String signalName) {
        return this.eventSubscription("signal", signalName);
    }

    @Override
    public ExecutionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    @Override
    public ExecutionQuery messageEventSubscription() {
        return this.eventSubscription("message", null);
    }

    public ExecutionQuery eventSubscription(String eventType, String eventName) {
        EnsureUtil.ensureNotNull("event type", (Object)eventType);
        if (!"message".equals(eventType)) {
            EnsureUtil.ensureNotNull("event name", (Object)eventName);
        }
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = new ArrayList<EventSubscriptionQueryValue>();
        }
        this.eventSubscriptions.add(new EventSubscriptionQueryValue(eventName, eventType));
        return this;
    }

    @Override
    public ExecutionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ExecutionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, false);
        return this;
    }

    @Override
    public ExecutionQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, false);
        return this;
    }

    @Override
    public ExecutionQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incident type", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public ExecutionQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incident id", (Object)incidentId);
        this.incidentId = incidentId;
        return this;
    }

    @Override
    public ExecutionQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incident message", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public ExecutionQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incident messageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessInstanceId() {
        this.orderBy(ExecutionQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionId() {
        this.orderBy(new QueryOrderingProperty("process-definition", ExecutionQueryProperty.PROCESS_DEFINITION_ID));
        return this;
    }

    @Override
    public ExecutionQueryImpl orderByProcessDefinitionKey() {
        this.orderBy(new QueryOrderingProperty("process-definition", ExecutionQueryProperty.PROCESS_DEFINITION_KEY));
        return this;
    }

    @Override
    public ExecutionQuery orderBySequenceCounter() {
        this.orderBy(ExecutionQueryProperty.SEQUENCE_COUNTER);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionManager().findExecutionCountByQueryCriteria(this);
    }

    @Override
    public List<Execution> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getExecutionManager().findExecutionsByQueryCriteria(this, page);
    }

    public boolean getOnlyProcessInstances() {
        return false;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessInstanceIds() {
        return null;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public String getSuperCaseInstanceId() {
        return this.superCaseInstanceId;
    }

    public String getSubCaseInstanceId() {
        return this.subCaseInstanceId;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public List<EventSubscriptionQueryValue> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public void setEventSubscriptions(List<EventSubscriptionQueryValue> eventSubscriptions) {
        this.eventSubscriptions = eventSubscriptions;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }
}

