/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.event;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationUnavailableException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class ProcessApplicationEventListenerDelegate
implements ExecutionListener,
TaskListener {
    private Logger LOG = Logger.getLogger(ProcessApplicationEventListenerDelegate.class.getName());

    @Override
    public void notify(final DelegateExecution execution) throws Exception {
        Callable<Void> notification = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ProcessApplicationEventListenerDelegate.this.notifyExecutionListener(execution);
                return null;
            }
        };
        this.performNotification(execution, notification);
    }

    @Override
    public void notify(final DelegateTask delegateTask) {
        if (delegateTask.getExecution() == null) {
            this.LOG.log(Level.FINE, "Task {0} not related to an execution, target process application cannot be determined.", new Object[]{delegateTask});
        } else {
            DelegateExecution execution = delegateTask.getExecution();
            Callable<Void> notification = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProcessApplicationEventListenerDelegate.this.notifyTaskListener(delegateTask);
                    return null;
                }
            };
            try {
                this.performNotification(execution, notification);
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while notifying process application task listener.", e);
            }
        }
    }

    protected void performNotification(DelegateExecution execution, Callable<Void> notification) throws Exception {
        ProcessApplicationReference processApp = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (processApp == null) {
            this.LOG.log(Level.FINE, "No target process application found for execution {0}", new Object[]{execution});
        } else if (ProcessApplicationContextUtil.requiresContextSwitch(processApp)) {
            Context.executeWithinProcessApplication(notification, processApp);
        } else {
            notification.call();
        }
    }

    protected void notifyExecutionListener(DelegateExecution execution) throws Exception {
        ProcessApplicationReference processApp = Context.getCurrentProcessApplication();
        try {
            ProcessApplicationInterface processApplication = processApp.getProcessApplication();
            ExecutionListener executionListener = processApplication.getExecutionListener();
            if (executionListener != null) {
                executionListener.notify(execution);
            } else {
                this.LOG.log(Level.FINE, "Target process application '" + processApp.getName() + "' does not provide an ExecutionListener.");
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            this.LOG.log(Level.FINE, "Target process application '" + processApp.getName() + "' unavailable", e);
        }
    }

    protected void notifyTaskListener(DelegateTask task) throws Exception {
        ProcessApplicationReference processApp = Context.getCurrentProcessApplication();
        try {
            ProcessApplicationInterface processApplication = processApp.getProcessApplication();
            TaskListener taskListener = processApplication.getTaskListener();
            if (taskListener != null) {
                taskListener.notify(task);
            } else {
                this.LOG.log(Level.FINE, "Target process application '" + processApp.getName() + "' does not provide a TaskListener.");
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            this.LOG.log(Level.FINE, "Target process application '" + processApp.getName() + "' unavailable", e);
        }
    }
}

