/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchElementConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricDecisionInstancesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricDecisionInstancesCmd
implements Command<Batch> {
    protected SetRemovalTimeToHistoricDecisionInstancesBuilderImpl builder;

    public SetRemovalTimeToHistoricDecisionInstancesCmd(SetRemovalTimeToHistoricDecisionInstancesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        if (this.builder.getQuery() == null && this.builder.getIds() == null) {
            throw new BadUserRequestException("Neither query nor ids provided.");
        }
        BatchElementConfiguration elementConfiguration = this.collectInstances(commandContext);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicDecisionInstances", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("decision-set-removal-time").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectInstances(CommandContext commandContext) {
        List<String> idList;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (this.builder.getQuery() != null) {
            elementConfiguration.addDeploymentMappings(((HistoricDecisionInstanceQueryImpl)this.builder.getQuery()).listDeploymentIdMappings());
        }
        if (!CollectionUtil.isEmpty(idList = this.builder.getIds())) {
            HistoricDecisionInstanceQueryImpl query = new HistoricDecisionInstanceQueryImpl();
            query.decisionInstanceIdIn(idList.toArray(new String[0]));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings));
        }
        return elementConfiguration;
    }

    protected HistoricDecisionInstanceQuery createHistoricDecisionInstanceQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricDecisionInstanceQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)this.builder.getMode()));
        propertyChanges.add(new PropertyChange("removalTime", null, this.builder.getRemovalTime()));
        propertyChanges.add(new PropertyChange("hierarchical", null, this.builder.isHierarchical()));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("SetRemovalTime", null, propertyChanges);
    }

    protected boolean hasRemovalTime() {
        return this.builder.getMode() == SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricDecisionInstancesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new SetRemovalTimeBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings()).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.hasRemovalTime()).setRemovalTime(this.builder.getRemovalTime());
    }
}

