/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.IntegerValue;

public class IntegerValueSerializer
extends PrimitiveValueSerializer<IntegerValue> {
    public IntegerValueSerializer() {
        super(ValueType.INTEGER);
    }

    @Override
    public IntegerValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.integerValue((Integer)((Integer)untypedValue.getValue()), (boolean)untypedValue.isTransient());
    }

    @Override
    public void writeValue(IntegerValue variableValue, ValueFields valueFields) {
        Integer value = (Integer)variableValue.getValue();
        if (value != null) {
            valueFields.setLongValue(value.longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    @Override
    public IntegerValue readValue(ValueFields valueFields, boolean asTransientValue) {
        Integer intValue = null;
        if (valueFields.getLongValue() != null) {
            intValue = valueFields.getLongValue().intValue();
        }
        return Variables.integerValue(intValue, (boolean)asTransientValue);
    }
}

