/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.migration.instance.EmergingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTimerJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class ActivityInstanceJobHandler
implements MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, List<JobEntity> elements) {
        Map<String, TimerDeclarationImpl> sourceTimerDeclarationsInEventScope = TimerDeclarationImpl.getDeclarationsForScope(activityInstance.getSourceScope());
        HashMap<String, TimerDeclarationImpl> targetTimerDeclarationsInEventScope = new HashMap<String, TimerDeclarationImpl>(TimerDeclarationImpl.getDeclarationsForScope(activityInstance.getTargetScope()));
        Map<String, Map<String, TimerDeclarationImpl>> sourceTimeoutListenerDeclarationsInEventScope = TimerDeclarationImpl.getTimeoutListenerDeclarationsForScope(activityInstance.getSourceScope());
        HashMap<String, Map<String, TimerDeclarationImpl>> targetTimeoutListenerDeclarationsInEventScope = new HashMap<String, Map<String, TimerDeclarationImpl>>(TimerDeclarationImpl.getTimeoutListenerDeclarationsForScope(activityInstance.getTargetScope()));
        for (JobEntity job : elements) {
            if (!ActivityInstanceJobHandler.isTimerJob(job)) continue;
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(job.getActivityId());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            JobHandlerConfiguration jobHandlerConfiguration = job.getJobHandlerConfiguration();
            if (targetActivity != null && activityInstance.migratesTo(targetActivity.getEventScope()) && ActivityInstanceJobHandler.isNoTimeoutListenerOrMigrates(job, jobHandlerConfiguration, targetActivity.getActivityId(), targetTimeoutListenerDeclarationsInEventScope)) {
                JobDefinitionEntity targetJobDefinitionEntity = parseContext.getTargetJobDefinition(targetActivity.getActivityId(), job.getJobHandlerType());
                TimerDeclarationImpl targetTimerDeclaration = this.getTargetTimerDeclaration(job, jobHandlerConfiguration, targetActivity.getActivityId(), targetTimeoutListenerDeclarationsInEventScope, targetTimerDeclarationsInEventScope);
                MigratingTimerJobInstance migratingTimerJobInstance = new MigratingTimerJobInstance(job, targetJobDefinitionEntity, targetActivity, migrationInstruction.isUpdateEventTrigger(), targetTimerDeclaration);
                activityInstance.addMigratingDependentInstance(migratingTimerJobInstance);
                parseContext.submit(migratingTimerJobInstance);
            } else {
                MigratingTimerJobInstance removingJobInstance = new MigratingTimerJobInstance(job);
                activityInstance.addRemovingDependentInstance(removingJobInstance);
                parseContext.submit(removingJobInstance);
            }
            parseContext.consume(job);
        }
        if (activityInstance.migrates()) {
            this.addEmergingTimerJobs(parseContext, activityInstance, sourceTimerDeclarationsInEventScope, targetTimerDeclarationsInEventScope);
            this.addEmergingTimeoutListenerJobs(parseContext, activityInstance, sourceTimeoutListenerDeclarationsInEventScope, targetTimeoutListenerDeclarationsInEventScope);
        }
    }

    protected TimerDeclarationImpl getTargetTimerDeclaration(JobEntity job, JobHandlerConfiguration jobHandlerConfiguration, String targetActivity, Map<String, Map<String, TimerDeclarationImpl>> targetTimeoutListenerDeclarationsInEventScope, Map<String, TimerDeclarationImpl> targetTimerDeclarationsInEventScope) {
        if (ActivityInstanceJobHandler.isTimeoutListenerJobInTargetScope(jobHandlerConfiguration, targetActivity, targetTimeoutListenerDeclarationsInEventScope)) {
            return ActivityInstanceJobHandler.removeTimeoutListenerJobFromTargetScope(jobHandlerConfiguration, targetActivity, targetTimeoutListenerDeclarationsInEventScope);
        }
        return targetTimerDeclarationsInEventScope.remove(targetActivity);
    }

    protected static boolean isTimerJob(JobEntity job) {
        return job != null && job.getType().equals("timer");
    }

    protected static boolean isNoTimeoutListenerOrMigrates(JobEntity job, JobHandlerConfiguration jobHandlerConfiguration, String targetActivity, Map<String, Map<String, TimerDeclarationImpl>> targetTimeoutListenerDeclarationsInEventScope) {
        return !"timer-task-listener".equals(job.getJobHandlerType()) || ActivityInstanceJobHandler.isTimeoutListenerJobInTargetScope(jobHandlerConfiguration, targetActivity, targetTimeoutListenerDeclarationsInEventScope);
    }

    protected static boolean isTimeoutListenerJobInTargetScope(JobHandlerConfiguration jobHandlerConfiguration, String targetActivity, Map<String, Map<String, TimerDeclarationImpl>> targetTimeoutListenerDeclarationsInEventScope) {
        return jobHandlerConfiguration instanceof TimerEventJobHandler.TimerJobConfiguration && targetTimeoutListenerDeclarationsInEventScope.containsKey(targetActivity) && targetTimeoutListenerDeclarationsInEventScope.get(targetActivity).containsKey(((TimerEventJobHandler.TimerJobConfiguration)jobHandlerConfiguration).getTimerElementSecondaryKey());
    }

    protected static TimerDeclarationImpl removeTimeoutListenerJobFromTargetScope(JobHandlerConfiguration jobHandlerConfiguration, String targetActivity, Map<String, Map<String, TimerDeclarationImpl>> targetTimeoutListenerDeclarationsInEventScope) {
        if (ActivityInstanceJobHandler.isTimeoutListenerJobInTargetScope(jobHandlerConfiguration, targetActivity, targetTimeoutListenerDeclarationsInEventScope)) {
            Map<String, TimerDeclarationImpl> activityDeclarations = targetTimeoutListenerDeclarationsInEventScope.get(targetActivity);
            TimerDeclarationImpl declaration = activityDeclarations.remove(((TimerEventJobHandler.TimerJobConfiguration)jobHandlerConfiguration).getTimerElementSecondaryKey());
            if (activityDeclarations.isEmpty()) {
                targetTimeoutListenerDeclarationsInEventScope.remove(targetActivity);
            }
            return declaration;
        }
        return null;
    }

    protected void addEmergingTimerJobs(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, Map<String, TimerDeclarationImpl> sourceTimerDeclarationsInEventScope, Map<String, TimerDeclarationImpl> targetTimerDeclarationsInEventScope) {
        for (TimerDeclarationImpl targetTimerDeclaration : targetTimerDeclarationsInEventScope.values()) {
            if (this.isNonInterruptingTimerTriggeredAlready(parseContext, sourceTimerDeclarationsInEventScope, targetTimerDeclaration)) continue;
            activityInstance.addEmergingDependentInstance(new EmergingJobInstance(targetTimerDeclaration));
        }
    }

    protected void addEmergingTimeoutListenerJobs(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, Map<String, Map<String, TimerDeclarationImpl>> sourceTimeoutListenerDeclarationsInEventScope, Map<String, Map<String, TimerDeclarationImpl>> targetTimeoutListenerDeclarationsInEventScope) {
        for (Map<String, TimerDeclarationImpl> targetTimerDeclarations : targetTimeoutListenerDeclarationsInEventScope.values()) {
            for (Map.Entry<String, TimerDeclarationImpl> targetTimerDeclaration : targetTimerDeclarations.entrySet()) {
                if (this.isNonInterruptingTimeoutListenerTriggeredAlready(parseContext, sourceTimeoutListenerDeclarationsInEventScope, targetTimerDeclaration)) continue;
                activityInstance.addEmergingDependentInstance(new EmergingJobInstance(targetTimerDeclaration.getValue()));
            }
        }
    }

    protected boolean isNonInterruptingTimerTriggeredAlready(MigratingInstanceParseContext parseContext, Map<String, TimerDeclarationImpl> sourceTimerDeclarationsInEventScope, TimerDeclarationImpl targetTimerDeclaration) {
        if (targetTimerDeclaration.isInterruptingTimer() || targetTimerDeclaration.getJobHandlerType() != "timer-transition" || sourceTimerDeclarationsInEventScope.values().size() == 0) {
            return false;
        }
        for (TimerDeclarationImpl sourceTimerDeclaration : sourceTimerDeclarationsInEventScope.values()) {
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(sourceTimerDeclaration.getActivityId());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            if (targetActivity == null || !targetTimerDeclaration.getActivityId().equals(targetActivity.getActivityId())) continue;
            return true;
        }
        return false;
    }

    protected boolean isNonInterruptingTimeoutListenerTriggeredAlready(MigratingInstanceParseContext parseContext, Map<String, Map<String, TimerDeclarationImpl>> sourceTimeoutListenerDeclarationsInEventScope, Map.Entry<String, TimerDeclarationImpl> targetTimerDeclarationEntry) {
        TimerDeclarationImpl targetTimerDeclaration = targetTimerDeclarationEntry.getValue();
        if (targetTimerDeclaration.isInterruptingTimer() || targetTimerDeclaration.getJobHandlerType() != "timer-task-listener" || sourceTimeoutListenerDeclarationsInEventScope.values().size() == 0) {
            return false;
        }
        for (Map.Entry<String, Map<String, TimerDeclarationImpl>> sourceTimerDeclarationsEntry : sourceTimeoutListenerDeclarationsInEventScope.entrySet()) {
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(sourceTimerDeclarationsEntry.getKey());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            if (targetActivity == null || !targetTimerDeclaration.getActivityId().equals(targetActivity.getActivityId())) continue;
            for (Map.Entry<String, TimerDeclarationImpl> sourceTimerDeclarationEntry : sourceTimerDeclarationsEntry.getValue().entrySet()) {
                if (!sourceTimerDeclarationEntry.getKey().equals(targetTimerDeclarationEntry.getKey())) continue;
                return true;
            }
        }
        return false;
    }
}

