/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.metrics.Meter;

public class MetricsRegistry {
    protected Map<String, Meter> dbMeters = new HashMap<String, Meter>();
    protected Map<String, Meter> diagnosticsMeters = new HashMap<String, Meter>();

    public Meter getDbMeterByName(String name) {
        return this.dbMeters.get(name);
    }

    public Map<String, Meter> getDbMeters() {
        return this.dbMeters;
    }

    public Map<String, Meter> getDiagnosticsMeters() {
        return this.diagnosticsMeters;
    }

    public void clearDiagnosticsMetrics() {
        this.diagnosticsMeters.values().forEach(Meter::getAndClear);
    }

    public void markOccurrence(String name) {
        this.markOccurrence(name, 1L);
    }

    public void markOccurrence(String name, long times) {
        this.markOccurrence(this.dbMeters, name, times);
        this.markOccurrence(this.diagnosticsMeters, name, times);
    }

    public void markDiagnosticsOccurrence(String name, long times) {
        this.markOccurrence(this.diagnosticsMeters, name, times);
    }

    protected void markOccurrence(Map<String, Meter> meters, String name, long times) {
        Meter meter = meters.get(name);
        if (meter != null) {
            meter.markTimes(times);
        }
    }

    public void createMeter(String name) {
        Meter dbMeter = new Meter(name);
        this.dbMeters.put(name, dbMeter);
        Meter diagnosticsMeter = new Meter(name);
        this.diagnosticsMeters.put(name, diagnosticsMeter);
    }

    public void createDbMeter(String name) {
        Meter dbMeter = new Meter(name);
        this.dbMeters.put(name, dbMeter);
    }
}

