/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.DetermineHistoryLevelCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;

public final class HistoryLevelSetupCommand
implements Command<Void> {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        this.checkStartupLockExists(commandContext);
        HistoryLevel databaseHistoryLevel = new DetermineHistoryLevelCmd(processEngineConfiguration.getHistoryLevels()).execute(commandContext);
        this.determineAutoHistoryLevel(processEngineConfiguration, databaseHistoryLevel);
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (databaseHistoryLevel == null) {
            this.acquireExclusiveLock(commandContext);
            databaseHistoryLevel = new DetermineHistoryLevelCmd(processEngineConfiguration.getHistoryLevels()).execute(commandContext);
            if (databaseHistoryLevel == null) {
                LOG.noHistoryLevelPropertyFound();
                HistoryLevelSetupCommand.dbCreateHistoryLevel(commandContext);
            }
        } else if (configuredHistoryLevel.getId() != databaseHistoryLevel.getId()) {
            throw new ProcessEngineException("historyLevel mismatch: configuration says " + configuredHistoryLevel + " and database says " + databaseHistoryLevel);
        }
        return null;
    }

    public static void dbCreateHistoryLevel(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        PropertyEntity property = new PropertyEntity("historyLevel", Integer.toString(configuredHistoryLevel.getId()));
        commandContext.getSession(DbEntityManager.class).insert(property);
        LOG.creatingHistoryLevelPropertyInDatabase(configuredHistoryLevel);
    }

    public static Integer databaseHistoryLevel(CommandContext commandContext) {
        try {
            PropertyEntity historyLevelProperty = commandContext.getPropertyManager().findPropertyById("historyLevel");
            return historyLevelProperty != null ? Integer.valueOf(historyLevelProperty.getValue()) : null;
        }
        catch (Exception e) {
            LOG.couldNotSelectHistoryLevel(e.getMessage());
            return null;
        }
    }

    protected void determineAutoHistoryLevel(ProcessEngineConfigurationImpl engineConfiguration, HistoryLevel databaseHistoryLevel) {
        HistoryLevel configuredHistoryLevel = engineConfiguration.getHistoryLevel();
        if (configuredHistoryLevel == null && "auto".equals(engineConfiguration.getHistory())) {
            if (databaseHistoryLevel != null) {
                engineConfiguration.setHistoryLevel(databaseHistoryLevel);
            } else {
                engineConfiguration.setHistoryLevel(engineConfiguration.getDefaultHistoryLevel());
            }
        }
    }

    protected void checkStartupLockExists(CommandContext commandContext) {
        PropertyEntity historyStartupProperty = commandContext.getPropertyManager().findPropertyById("startup.lock");
        if (historyStartupProperty == null) {
            LOG.noStartupLockPropertyFound();
        }
    }

    protected void acquireExclusiveLock(CommandContext commandContext) {
        PropertyManager propertyManager = commandContext.getPropertyManager();
        propertyManager.acquireExclusiveLockForStartup();
    }
}

