/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment;

import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedBpmPlatformPlugins;
import org.camunda.bpm.container.impl.plugin.BpmPlatformPlugins;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;

public class DiscoverBpmPlatformPluginsStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Discover BPM Platform Plugins";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        BpmPlatformPlugins plugins = BpmPlatformPlugins.load(this.getPluginsClassloader());
        JmxManagedBpmPlatformPlugins jmxManagedPlugins = new JmxManagedBpmPlatformPlugins(plugins);
        serviceContainer.startService(ServiceTypes.BPM_PLATFORM, "bpm-platform-plugins", jmxManagedPlugins);
    }

    protected ClassLoader getPluginsClassloader() {
        ClassLoader pluginsClassLoader = ClassLoaderUtil.getContextClassloader();
        if (pluginsClassLoader == null) {
            pluginsClassLoader = BpmPlatform.class.getClassLoader();
        }
        return pluginsClassLoader;
    }
}

