/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbReferences;

public class TaskMeterLogEntity
implements DbEntity,
HasDbReferences,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected Date timestamp;
    protected long assigneeHash;

    public TaskMeterLogEntity(String assignee, Date timestamp) {
        this.assigneeHash = this.createHashAsLong(assignee);
        this.timestamp = timestamp;
    }

    protected long createHashAsLong(String assignee) {
        String algorithm = "MD5";
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(assignee.getBytes(StandardCharsets.UTF_8));
            return ByteBuffer.wrap(digest.digest(), 0, 8).getLong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessEngineException("Cannot lookup hash algorithm '" + algorithm + "'");
        }
    }

    public TaskMeterLogEntity() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public long getAssigneeHash() {
        return this.assigneeHash;
    }

    public void setAssigneeHash(long assigneeHash) {
        this.assigneeHash = assigneeHash;
    }

    @Override
    public Object getPersistentState() {
        return TaskMeterLogEntity.class;
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referencedEntityIds = new HashSet<String>();
        return referencedEntityIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        return referenceIdAndClass;
    }
}

