/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import java.io.InputStream;
import java.util.List;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ModelInstanceCache;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;

public class DmnModelInstanceCache
extends ModelInstanceCache<DmnModelInstance, DecisionDefinitionEntity> {
    public DmnModelInstanceCache(CacheFactory factory, int cacheCapacity, ResourceDefinitionCache<DecisionDefinitionEntity> definitionCache) {
        super(factory, cacheCapacity, definitionCache);
    }

    @Override
    protected void throwLoadModelException(String definitionId, Exception e) {
        throw LOG.loadModelException("DMN", "decision", definitionId, e);
    }

    @Override
    protected DmnModelInstance readModelFromStream(InputStream cmmnResourceInputStream) {
        return Dmn.readModelFromStream((InputStream)cmmnResourceInputStream);
    }

    @Override
    protected void logRemoveEntryFromDeploymentCacheFailure(String definitionId, Exception e) {
        LOG.removeEntryFromDeploymentCacheFailure("decision", definitionId, e);
    }

    @Override
    protected List<DecisionDefinition> getAllDefinitionsForDeployment(String deploymentId) {
        return new DecisionDefinitionQueryImpl().deploymentId(deploymentId).list();
    }
}

