/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history;

import java.util.Calendar;
import java.util.Date;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class DefaultHistoryRemovalTimeProvider
implements HistoryRemovalTimeProvider {
    @Override
    public Date calculateRemovalTime(HistoricProcessInstanceEventEntity historicRootProcessInstance, ProcessDefinition processDefinition) {
        Integer historyTimeToLive = processDefinition.getHistoryTimeToLive();
        if (historyTimeToLive != null) {
            if (this.isProcessInstanceRunning(historicRootProcessInstance)) {
                Date startTime = historicRootProcessInstance.getStartTime();
                return DefaultHistoryRemovalTimeProvider.determineRemovalTime(startTime, historyTimeToLive);
            }
            if (this.isProcessInstanceEnded(historicRootProcessInstance)) {
                Date endTime = historicRootProcessInstance.getEndTime();
                return DefaultHistoryRemovalTimeProvider.determineRemovalTime(endTime, historyTimeToLive);
            }
        }
        return null;
    }

    @Override
    public Date calculateRemovalTime(HistoricDecisionInstanceEntity historicRootDecisionInstance, DecisionDefinition decisionDefinition) {
        Integer historyTimeToLive = decisionDefinition.getHistoryTimeToLive();
        if (historyTimeToLive != null) {
            Date evaluationTime = historicRootDecisionInstance.getEvaluationTime();
            return DefaultHistoryRemovalTimeProvider.determineRemovalTime(evaluationTime, historyTimeToLive);
        }
        return null;
    }

    @Override
    public Date calculateRemovalTime(HistoricBatchEntity historicBatch) {
        Integer historyTimeToLive;
        String batchOperation = historicBatch.getType();
        if (batchOperation != null && (historyTimeToLive = this.getTTLByBatchOperation(batchOperation)) != null) {
            if (this.isBatchRunning(historicBatch)) {
                Date startTime = historicBatch.getStartTime();
                return DefaultHistoryRemovalTimeProvider.determineRemovalTime(startTime, historyTimeToLive);
            }
            if (this.isBatchEnded(historicBatch)) {
                Date endTime = historicBatch.getEndTime();
                return DefaultHistoryRemovalTimeProvider.determineRemovalTime(endTime, historyTimeToLive);
            }
        }
        return null;
    }

    protected boolean isBatchRunning(HistoricBatchEntity historicBatch) {
        return historicBatch.getEndTime() == null;
    }

    protected boolean isBatchEnded(HistoricBatchEntity historicBatch) {
        return historicBatch.getEndTime() != null;
    }

    protected Integer getTTLByBatchOperation(String batchOperation) {
        return Context.getCommandContext().getProcessEngineConfiguration().getParsedBatchOperationsForHistoryCleanup().get(batchOperation);
    }

    protected boolean isProcessInstanceRunning(HistoricProcessInstanceEventEntity historicProcessInstance) {
        return historicProcessInstance.getEndTime() == null;
    }

    protected boolean isProcessInstanceEnded(HistoricProcessInstanceEventEntity historicProcessInstance) {
        return historicProcessInstance.getEndTime() != null;
    }

    public static Date determineRemovalTime(Date initTime, Integer timeToLive) {
        Calendar removalTime = Calendar.getInstance();
        removalTime.setTime(initTime);
        removalTime.add(5, timeToLive);
        return removalTime.getTime();
    }
}

