/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.entitymanager.operation;

import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.Recyclable;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperationType;

public abstract class DbOperation
implements Recyclable {
    protected DbOperationType operationType;
    protected int rowsAffected;
    protected Exception failure;
    protected State state;
    protected Class<? extends DbEntity> entityType;

    @Override
    public void recycle() {
        this.operationType = null;
        this.entityType = null;
    }

    public Class<? extends DbEntity> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<? extends DbEntity> entityType) {
        this.entityType = entityType;
    }

    public DbOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(DbOperationType operationType) {
        this.operationType = operationType;
    }

    public int getRowsAffected() {
        return this.rowsAffected;
    }

    public void setRowsAffected(int rowsAffected) {
        this.rowsAffected = rowsAffected;
    }

    public boolean isFailed() {
        return this.state == State.FAILED_CONCURRENT_MODIFICATION || this.state == State.FAILED_CONCURRENT_MODIFICATION_EXCEPTION || this.state == State.FAILED_ERROR;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public void setFailure(Exception failure) {
        this.failure = failure;
    }

    public static enum State {
        NOT_APPLIED,
        APPLIED,
        FAILED_ERROR,
        FAILED_CONCURRENT_MODIFICATION,
        FAILED_CONCURRENT_MODIFICATION_EXCEPTION;

    }
}

