/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.repository;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryProperty;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.CompareUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;

public class CaseDefinitionQueryImpl
extends AbstractQuery<CaseDefinitionQuery, CaseDefinition>
implements CaseDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected boolean includeDefinitionsWithoutTenantId = false;

    public CaseDefinitionQueryImpl() {
    }

    public CaseDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CaseDefinitionQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionId", (Object)caseDefinitionId);
        this.id = caseDefinitionId;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionIdIn(String ... ids) {
        this.ids = ids;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionCategory(String caseDefinitionCategory) {
        EnsureUtil.ensureNotNull(NotValidException.class, "category", (Object)caseDefinitionCategory);
        this.category = caseDefinitionCategory;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionCategoryLike(String caseDefinitionCategoryLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "categoryLike", (Object)caseDefinitionCategoryLike);
        this.categoryLike = caseDefinitionCategoryLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionName(String caseDefinitionName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "name", (Object)caseDefinitionName);
        this.name = caseDefinitionName;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionNameLike(String caseDefinitionNameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "nameLike", (Object)caseDefinitionNameLike);
        this.nameLike = caseDefinitionNameLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "key", (Object)caseDefinitionKey);
        this.key = caseDefinitionKey;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionKeyLike(String caseDefinitionKeyLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "keyLike", (Object)caseDefinitionKeyLike);
        this.keyLike = caseDefinitionKeyLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionVersion(Integer caseDefinitionVersion) {
        EnsureUtil.ensureNotNull(NotValidException.class, "version", (Object)caseDefinitionVersion);
        EnsureUtil.ensurePositive(NotValidException.class, "version", (Long)caseDefinitionVersion.longValue());
        this.version = caseDefinitionVersion;
        return this;
    }

    @Override
    public CaseDefinitionQuery latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionResourceName(String resourceName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceName", (Object)resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public CaseDefinitionQuery caseDefinitionResourceNameLike(String resourceNameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceNameLike", (Object)resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public CaseDefinitionQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CaseDefinitionQuery withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantIds = null;
        return this;
    }

    @Override
    public CaseDefinitionQuery includeCaseDefinitionsWithoutTenantId() {
        this.includeDefinitionsWithoutTenantId = true;
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionCategory() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_CATEGORY);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionKey() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_KEY);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionId() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionVersion() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_VERSION);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByCaseDefinitionName() {
        this.orderBy(CaseDefinitionQueryProperty.CASE_DEFINITION_NAME);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByDeploymentId() {
        this.orderBy(CaseDefinitionQueryProperty.DEPLOYMENT_ID);
        return this;
    }

    @Override
    public CaseDefinitionQuery orderByTenantId() {
        return (CaseDefinitionQuery)this.orderBy(CaseDefinitionQueryProperty.TENANT_ID);
    }

    @Override
    protected boolean hasExcludingConditions() {
        return super.hasExcludingConditions() || CompareUtil.elementIsNotContainedInArray(this.id, this.ids);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        if (this.isCmmnEnabled(commandContext)) {
            this.checkQueryOk();
            return commandContext.getCaseDefinitionManager().findCaseDefinitionCountByQueryCriteria(this);
        }
        return 0L;
    }

    @Override
    public List<CaseDefinition> executeList(CommandContext commandContext, Page page) {
        if (this.isCmmnEnabled(commandContext)) {
            this.checkQueryOk();
            return commandContext.getCaseDefinitionManager().findCaseDefinitionsByQueryCriteria(this, page);
        }
        return Collections.emptyList();
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.name != null || this.nameLike != null || this.version != null || this.deploymentId != null)) {
            throw new NotValidException("Calling latest() can only be used in combination with key(String) and keyLike(String)");
        }
    }

    private boolean isCmmnEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isCmmnEnabled();
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }
}

