/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetDeploymentCaseModelCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;

    public GetDeploymentCaseModelCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)this.caseDefinitionId);
        CaseDefinitionEntity caseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseDefinition(caseDefinition);
        }
        String deploymentId = caseDefinition.getDeploymentId();
        String resourceName = caseDefinition.getResourceName();
        InputStream inputStream = commandContext.runWithoutAuthorization(new GetDeploymentResourceCmd(deploymentId, resourceName));
        return inputStream;
    }
}

