/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class GetCaseExecutionVariableTypedCmd
implements Command<TypedValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseExecutionId;
    protected String variableName;
    protected boolean isLocal;
    protected boolean deserializeValue;

    public GetCaseExecutionVariableTypedCmd(String caseExecutionId, String variableName, boolean isLocal, boolean deserializeValue) {
        this.caseExecutionId = caseExecutionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
        this.deserializeValue = deserializeValue;
    }

    @Override
    public TypedValue execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)this.caseExecutionId);
        EnsureUtil.ensureNotNull("variableName", (Object)this.variableName);
        CaseExecutionEntity caseExecution = commandContext.getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        EnsureUtil.ensureNotNull(CaseExecutionNotFoundException.class, "case execution " + this.caseExecutionId + " doesn't exist", "caseExecution", (Object)caseExecution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseInstance(caseExecution);
        }
        Object value = this.isLocal ? caseExecution.getVariableLocalTyped(this.variableName, this.deserializeValue) : caseExecution.getVariableTyped(this.variableName, this.deserializeValue);
        return value;
    }
}

